/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@SerializableAs(value="ItemQueue")
public class ItemQueue
implements ConfigurationSerializable {
    private Deque<ItemStack> queue = new ArrayDeque<ItemStack>();

    ItemQueue() {
    }

    private ItemQueue(Collection<? extends ItemStack> queue) {
        this();
        this.queue.addAll(queue);
    }

    void addItems(ItemStack items) {
        assert (items != null);
        this.queue.add(items);
    }

    boolean isEmpty() {
        return this.queue.isEmpty();
    }

    boolean process(Inventory inventory, ConsoleCommandSender console, String targetUsername, String inventoryType) {
        boolean success = true;
        ItemStack last = null;
        while (!this.queue.isEmpty() && success) {
            ItemStack item = this.queue.poll();
            ItemStack clone = item.clone();
            HashMap map = inventory.addItem(new ItemStack[]{item});
            success = map.isEmpty();
            if (!success) {
                last = (ItemStack)map.get(0);
                console.sendMessage(ChatColor.YELLOW + "[Queue] Could not add all of " + clone + " to " + targetUsername + "'s " + inventoryType + ".");
                console.sendMessage(ChatColor.YELLOW + "[Queue] Remaining: " + last + (this.queue.isEmpty() ? "" : " and " + this.queue.stream().map(ItemStack::toString).collect(Collectors.joining(", "))) + ".");
                continue;
            }
            console.sendMessage(ChatColor.GREEN + "[Queue] Added " + clone + " to " + targetUsername + "'s " + inventoryType + "!");
        }
        if (!success) {
            assert (last != null);
            this.queue.addFirst(last);
        }
        return success;
    }

    public Map<String, Object> serialize() {
        return Collections.singletonMap("queue", new ArrayList<ItemStack>(this.queue));
    }

    public static ItemQueue deserialize(Map<String, Object> map) {
        List queue = (List)map.get("queue");
        return new ItemQueue(queue);
    }
}

