/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give;

import com.janboerman.invsee.spigot.addon.give.GivePlugin;
import com.janboerman.invsee.spigot.addon.give.ItemQueue;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

class ItemQueueManager {
    private static final String INVENTORY_QUEUE = "inventory-queue";
    private static final String ENDERCHEST_QUEUE = "enderchest-queue";
    private final GivePlugin plugin;
    private final Map<UUID, ItemQueue> inventoryQueues = new HashMap<UUID, ItemQueue>();
    private final Map<UUID, ItemQueue> enderchestQueues = new HashMap<UUID, ItemQueue>();
    private final File saveFolder;

    ItemQueueManager(GivePlugin plugin) {
        this.plugin = plugin;
        this.saveFolder = new File(plugin.getDataFolder(), "item queues");
    }

    void load() {
        File[] saveFiles;
        if (!this.saveFolder.exists()) {
            this.saveFolder.mkdirs();
        }
        if ((saveFiles = this.saveFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File saveFile : saveFiles) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)saveFile);
                String fileName = saveFile.getName();
                UUID uuid = UUID.fromString(fileName.substring(0, fileName.length() - 4));
                ItemQueue inventoryQueue = (ItemQueue)yamlConfiguration.get(INVENTORY_QUEUE);
                ItemQueue enderchestQueue = (ItemQueue)yamlConfiguration.get(ENDERCHEST_QUEUE);
                this.inventoryQueues.put(uuid, inventoryQueue);
                this.enderchestQueues.put(uuid, enderchestQueue);
            }
        }
    }

    ItemQueue getInventoryQueue(UUID player) {
        return this.inventoryQueues.computeIfAbsent(player, k -> new ItemQueue());
    }

    ItemQueue getEnderchestQueue(UUID player) {
        return this.enderchestQueues.computeIfAbsent(player, k -> new ItemQueue());
    }

    void enqueueInventory(UUID player, ItemStack items) {
        ItemQueue invQueue = this.getInventoryQueue(player);
        invQueue.addItems(items);
        this.save(player, invQueue, this.getEnderchestQueue(player));
    }

    void enqueueEnderchest(UUID player, ItemStack items) {
        ItemQueue enderQueue = this.getEnderchestQueue(player);
        enderQueue.addItems(items);
        this.save(player, this.getInventoryQueue(player), enderQueue);
    }

    void save(UUID player, ItemQueue inventoryQueue, ItemQueue enderchestQueue) {
        assert (player != null && inventoryQueue != null && enderchestQueue != null);
        File saveFile = new File(this.saveFolder, player.toString() + ".yml");
        if (inventoryQueue.isEmpty() && enderchestQueue.isEmpty()) {
            if (saveFile.exists()) {
                saveFile.delete();
            }
            this.inventoryQueues.remove(player);
            this.enderchestQueues.remove(player);
        } else {
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            yamlConfiguration.set(INVENTORY_QUEUE, (Object)inventoryQueue);
            yamlConfiguration.set(ENDERCHEST_QUEUE, (Object)enderchestQueue);
            try {
                yamlConfiguration.save(saveFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save player save file: " + saveFile.getName(), e);
            }
        }
    }
}

