/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give;

import com.janboerman.invsee.spigot.addon.give.GivePlugin;
import com.janboerman.invsee.spigot.addon.give.ItemQueue;
import com.janboerman.invsee.spigot.addon.give.ItemQueueManager;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;

public class JoinListener
implements Listener {
    private final GivePlugin plugin;
    private final ItemQueueManager queueManager;

    JoinListener(GivePlugin plugin, ItemQueueManager queueManager) {
        this.plugin = plugin;
        this.queueManager = queueManager;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String name = player.getName();
        ItemQueue inventoryQueue = this.queueManager.getInventoryQueue(uuid);
        ItemQueue enderchestQueue = this.queueManager.getEnderchestQueue(uuid);
        inventoryQueue.process((Inventory)player.getInventory(), this.plugin.getServer().getConsoleSender(), name, "inventory");
        enderchestQueue.process(player.getEnderChest(), this.plugin.getServer().getConsoleSender(), name, "enderchest");
        this.queueManager.save(uuid, inventoryQueue, enderchestQueue);
    }
}

