/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give.common;

import com.janboerman.invsee.spigot.addon.give.common.ItemType;
import com.janboerman.invsee.utils.Either;
import java.util.UUID;
import org.bukkit.Material;

public class Convert {
    private Convert() {
    }

    public static Either<UUID, String> convertPlayer(String input) {
        assert (input != null);
        try {
            UUID uuid = UUID.fromString(input);
            return Either.left((Object)uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Either.right((Object)input);
        }
    }

    public static Either<String, ItemType> convertItemType(String input) {
        Byte dataValue;
        String materialName;
        assert (input != null);
        int colonIndex = input.indexOf(58);
        if (colonIndex != -1) {
            materialName = input.substring(0, colonIndex);
            try {
                dataValue = Byte.parseByte(input.substring(colonIndex + 1));
            }
            catch (NumberFormatException e) {
                return Either.left((Object)e.getMessage());
            }
        } else {
            materialName = input;
            dataValue = null;
        }
        Material material = Material.matchMaterial((String)materialName);
        if (material != null) {
            if (dataValue != null) {
                return Either.right((Object)ItemType.withData(material, dataValue));
            }
            return Either.right((Object)ItemType.plain(material));
        }
        return Either.left((Object)("Material " + input + " does not exist."));
    }

    public static Either<String, Integer> convertAmount(String input) {
        assert (input != null);
        try {
            int value = Integer.parseInt(input);
            if (value > 0) {
                return Either.right((Object)value);
            }
            return Either.left((Object)(input + " is not a positive integer."));
        }
        catch (IllegalArgumentException e) {
            return Either.left((Object)(input + " is not a positive integer."));
        }
    }
}

