/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give.common;

import com.janboerman.invsee.utils.Either;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public interface ItemType {
    public static ItemType plain(Material material) {
        return new Plain(material);
    }

    public static ItemType withData(Material material, byte data) {
        return new WithData(material, data);
    }

    public Either<String, ItemStack> toItemStack(int var1);

    public static class Plain
    implements ItemType {
        private final Material material;

        Plain(Material material) {
            this.material = Objects.requireNonNull(material);
        }

        @Override
        public Either<String, ItemStack> toItemStack(int amount) {
            return Either.right((Object)new ItemStack(this.material, amount));
        }

        public String toString() {
            return this.material.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plain)) {
                return false;
            }
            Plain that = (Plain)o;
            return this.material == that.material;
        }

        public int hashCode() {
            return Objects.hashCode(this.material);
        }
    }

    public static class WithData
    implements ItemType {
        private final Material material;
        private final byte data;

        WithData(Material material, byte data) {
            this.material = Objects.requireNonNull(material);
            this.data = data;
        }

        @Override
        public Either<String, ItemStack> toItemStack(int amount) {
            return Either.right((Object)new ItemStack(this.material, amount, 0, Byte.valueOf(this.data)));
        }

        public String toString() {
            return this.material.toString() + ":" + this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithData)) {
                return false;
            }
            WithData that = (WithData)o;
            return this.material == that.material && this.data == that.data;
        }

        public int hashCode() {
            return Objects.hash(this.material, this.data);
        }
    }
}

