/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.give.glowstone;

import com.janboerman.invsee.spigot.addon.give.common.NeditImpl;
import com.janboerman.invsee.spigot.addon.give.glowstone.GlowstoneHacks;
import java.util.Map;
import java.util.stream.Collectors;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.NBTList;
import net.glowstone.inventory.GlowItemFactory;
import net.glowstone.util.nbt.ByteArrayTag;
import net.glowstone.util.nbt.ByteTag;
import net.glowstone.util.nbt.CompoundTag;
import net.glowstone.util.nbt.DoubleTag;
import net.glowstone.util.nbt.FloatTag;
import net.glowstone.util.nbt.IntArrayTag;
import net.glowstone.util.nbt.IntTag;
import net.glowstone.util.nbt.ListTag;
import net.glowstone.util.nbt.LongTag;
import net.glowstone.util.nbt.ShortTag;
import net.glowstone.util.nbt.StringTag;
import net.glowstone.util.nbt.Tag;
import net.glowstone.util.nbt.TagType;
import org.bukkit.inventory.ItemStack;

public class GiveImpl
extends NeditImpl {
    public static final GiveImpl INSTANCE = new GiveImpl();

    private GiveImpl() {
    }

    @Override
    protected ItemStack applyTag(ItemStack stack, NBTCompound tag) {
        stack.setItemMeta(GlowItemFactory.instance().readNbt(stack.getType(), GiveImpl.convert(tag)));
        return stack;
    }

    private static Tag convert(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return new ByteTag(((Byte)o).byteValue());
        }
        if (o instanceof Short) {
            return new ShortTag(((Short)o).shortValue());
        }
        if (o instanceof Integer) {
            return new IntTag(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return new LongTag(((Long)o).longValue());
        }
        if (o instanceof Float) {
            return new FloatTag(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new DoubleTag(((Double)o).doubleValue());
        }
        if (o instanceof byte[]) {
            return new ByteArrayTag((byte[])o);
        }
        if (o instanceof String) {
            return new StringTag((String)o);
        }
        if (o instanceof NBTList) {
            return GiveImpl.convert((NBTList)o);
        }
        if (o instanceof NBTCompound) {
            return GiveImpl.convert((NBTCompound)o);
        }
        if (o instanceof int[]) {
            return new IntArrayTag((int[])o);
        }
        if (o instanceof long[]) {
            throw new UnsupportedOperationException("Long_Array NBT Tag type unsupported on Glowstone!");
        }
        throw new UnsupportedOperationException("Cannot convert " + o + " to its nbt-equivalent");
    }

    private static CompoundTag convert(NBTCompound tag) {
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<String, Object> entry : tag.entrySet()) {
            GlowstoneHacks.put(compoundTag, entry.getKey(), GiveImpl.convert(entry.getValue()));
        }
        return compoundTag;
    }

    private static ListTag convert(NBTList tag) {
        return new ListTag(TagType.byId((int)tag.getContentType().getId()), tag.stream().map(GiveImpl::convert).collect(Collectors.toList()));
    }

    @Override
    public int maxStackSize() {
        return 64;
    }
}

