/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import me.nullicorn.nedit.exception.NBTSerializationException;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.NBTList;
import me.nullicorn.nedit.type.TagType;

public class NBTOutputStream
extends DataOutputStream {
    public NBTOutputStream(OutputStream out, boolean compress) throws IOException {
        super(compress ? new GZIPOutputStream(out) : out);
    }

    public void writeFully(NBTCompound compound) throws IOException {
        if (compound == null) {
            this.writeTagType(TagType.END);
        } else {
            this.writeTagType(TagType.COMPOUND);
            this.writeString("");
            this.writeCompound(compound);
            if (this.out instanceof GZIPOutputStream) {
                ((GZIPOutputStream)this.out).finish();
            }
        }
    }

    public void writeTagType(TagType type) throws IOException {
        if (type == null) {
            this.writeTagType(TagType.END);
            return;
        }
        this.writeByte((byte)type.getId());
    }

    public void writeValue(Object value) throws IOException {
        TagType tagType = TagType.fromObject(value);
        switch (tagType) {
            case BYTE: {
                this.writeByte(((Byte)value).byteValue());
                break;
            }
            case SHORT: {
                this.writeShort(((Short)value).shortValue());
                break;
            }
            case INT: {
                this.writeInt((Integer)value);
                break;
            }
            case LONG: {
                this.writeLong((Long)value);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)value);
                break;
            }
            case STRING: {
                this.writeString((String)value);
                break;
            }
            case LIST: {
                this.writeList((NBTList)value);
                break;
            }
            case COMPOUND: {
                this.writeCompound((NBTCompound)value);
                break;
            }
            case BYTE_ARRAY: {
                this.writeByteArray((byte[])value);
                break;
            }
            case INT_ARRAY: {
                this.writeIntArray((int[])value);
                break;
            }
            case LONG_ARRAY: {
                this.writeLongArray((long[])value);
                break;
            }
            case END: {
                throw new NBTSerializationException("Tag " + (Object)((Object)tagType) + " cannot be written as a value");
            }
        }
    }

    public void writeCompound(NBTCompound compound) throws IOException {
        this.writeCompound(compound, true);
    }

    public void writeCompound(NBTCompound compound, boolean close) throws IOException {
        for (Map.Entry<String, Object> tag : compound.entrySet()) {
            this.writeTagType(TagType.fromObject(tag.getValue()));
            this.writeString(tag.getKey());
            this.writeValue(tag.getValue());
        }
        if (close) {
            this.writeTagType(TagType.END);
        }
    }

    public void writeList(NBTList list) throws IOException {
        if (list == null) {
            this.writeTagType(TagType.END);
            this.writeInt(0);
            return;
        }
        this.writeTagType(list.getContentType());
        this.writeInt(list.size());
        for (Object item : list) {
            this.writeValue(item);
        }
    }

    public void writeLongArray(long[] longs) throws IOException {
        if (longs == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(longs.length);
        long[] lArray = longs;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long item = lArray[i];
            this.writeLong(item);
        }
    }

    public void writeIntArray(int[] ints) throws IOException {
        if (ints == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(ints.length);
        int[] nArray = ints;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer item = nArray[i];
            this.writeInt(item);
        }
    }

    public void writeByteArray(byte[] bytes) throws IOException {
        if (bytes == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(bytes.length);
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte item = byArray[i];
            this.writeByte(item.byteValue());
        }
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            this.writeInt(0);
            return;
        }
        byte[] strBytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeUnsignedShort(strBytes.length);
        this.write(strBytes);
    }

    protected void writeUnsignedShort(int value) throws IOException {
        this.writeChar(value);
    }
}

