/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import me.nullicorn.nedit.NBTOutputStream;
import me.nullicorn.nedit.type.NBTCompound;

public final class NBTWriter {
    public static byte[] writeToBase64(NBTCompound data) throws IOException {
        return NBTWriter.writeToBase64(data, true);
    }

    public static byte[] writeToBase64(NBTCompound data, boolean useCompression) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NBTWriter.write(data, out, useCompression);
        return Base64.getEncoder().encode(out.toByteArray());
    }

    public static void writeToFile(NBTCompound data, File file) throws IOException {
        NBTWriter.writeToFile(data, file, true);
    }

    public static void writeToFile(NBTCompound data, File file, boolean useCompression) throws IOException {
        file.mkdirs();
        if (file.getParentFile().exists()) {
            try (FileOutputStream fileOut = new FileOutputStream(file);){
                NBTWriter.write(data, fileOut, useCompression);
            }
        } else {
            throw new FileNotFoundException("Failed to create required directories for " + file);
        }
    }

    public static void write(NBTCompound data, OutputStream outputStream) throws IOException {
        NBTWriter.write(data, outputStream, true);
    }

    public static void write(NBTCompound data, OutputStream outputStream, boolean useCompression) throws IOException {
        new NBTOutputStream(outputStream, useCompression).writeFully(data);
    }

    private NBTWriter() {
        throw new UnsupportedOperationException("NBTWriter should not be instantiated");
    }
}

