/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import me.nullicorn.nedit.exception.NBTParseException;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.NBTList;
import me.nullicorn.nedit.type.TagType;

public final class SNBTReader {
    private static final char COMPOUND_START = '{';
    private static final char COMPOUND_END = '}';
    private static final char ENTRY_VALUE_INDICATOR = ':';
    private static final char ENTRY_SEPARATOR = ',';
    private static final char ARRAY_START = '[';
    private static final char ARRAY_END = ']';
    private static final char ARRAY_TYPE_INDICATOR = ';';
    private static final char STRING_DELIMITER_1 = '\"';
    private static final char STRING_DELIMITER_2 = '\'';
    private static final char STRING_ESCAPE = '\\';
    private static final String BYTE_PATTERN = "^[+-]?\\d+[Bb]$";
    private static final String SHORT_PATTERN = "^[+-]?\\d+[Ss]$";
    private static final String INT_PATTERN = "^[+-]?\\d+$";
    private static final String LONG_PATTERN = "^[+-]?\\d+[Ll]$";
    private static final String FLOAT_PATTERN = "^[+-]?[0-9]*\\.?[0-9]+[Ff]$";
    private static final String DOUBLE_PATTERN = "^[+-]?[0-9]*\\.?[0-9]+[Dd]$";
    private static final String LITERAL_SUFFIX_PATTERN = "[BbDdFfLlSs]$";
    private static final String VALID_UNQUOTED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_.";

    public static Object read(String snbt) throws IOException {
        return SNBTReader.read(snbt, false, false);
    }

    public static Object read(String snbt, boolean internNames, boolean internValues) throws IOException {
        return SNBTReader.read(new StringReader(snbt.trim()), internNames, internValues);
    }

    public static NBTCompound readCompound(String snbt) throws IOException {
        return SNBTReader.readCompound(snbt, false, false);
    }

    public static NBTCompound readCompound(String snbt, boolean internNames, boolean internValues) throws IOException {
        return SNBTReader.readCompound(new StringReader(snbt.trim()), internNames, internValues);
    }

    public static NBTList readList(String snbt) throws IOException {
        return SNBTReader.readList(snbt, false, false);
    }

    public static NBTList readList(String snbt, boolean internNames, boolean internValues) throws IOException {
        return SNBTReader.readList(new StringReader(snbt.trim()), internNames, internValues);
    }

    private static Object read(Reader reader, boolean internNames, boolean internValues) throws IOException {
        int firstChar = SNBTReader.peekChar(reader);
        switch (firstChar) {
            case 123: {
                return SNBTReader.readCompound(reader, internNames, internValues);
            }
            case 91: {
                return SNBTReader.readIterable(reader, internNames, internValues);
            }
        }
        return SNBTReader.readLiteral(reader, internValues);
    }

    private static NBTCompound readCompound(Reader reader, boolean internNames, boolean internValues) throws IOException {
        NBTCompound compound = new NBTCompound();
        if (SNBTReader.readChar(reader) != 123) {
            throw new NBTParseException("Invalid start of SNBT TAG_Compound");
        }
        do {
            SNBTReader.skipWhitespace(reader);
            reader.mark(1);
            if (SNBTReader.readChar(reader) == 125) break;
            reader.reset();
            String key = SNBTReader.readString(reader, internNames);
            SNBTReader.skipWhitespace(reader);
            if (SNBTReader.readChar(reader) != 58) {
                throw new NBTParseException("Invalid value indicator in SNBT TAG_Compound");
            }
            SNBTReader.skipWhitespace(reader);
            compound.put(key, SNBTReader.read(reader, internNames, internValues));
            SNBTReader.skipWhitespace(reader);
        } while (SNBTReader.readChar(reader) == 44);
        return compound;
    }

    private static Object readIterable(Reader reader, boolean internNames, boolean internValues) throws IOException {
        TagType arrayType;
        block10: {
            block9: {
                reader.mark(3);
                if (SNBTReader.readChar(reader) != 91) {
                    throw new NBTParseException("Invalid start of SNBT iterable");
                }
                int secondChar = SNBTReader.readChar(reader);
                int thirdChar = SNBTReader.readChar(reader);
                if (thirdChar != 59) break block9;
                switch (secondChar) {
                    case 66: {
                        arrayType = TagType.BYTE_ARRAY;
                        break block10;
                    }
                    case 73: {
                        arrayType = TagType.INT_ARRAY;
                        break block10;
                    }
                    case 76: {
                        arrayType = TagType.LONG_ARRAY;
                        break block10;
                    }
                    default: {
                        throw new NBTParseException("Unknown SNBT array type");
                    }
                }
            }
            reader.reset();
            return SNBTReader.readList(reader, internNames, internValues);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        do {
            SNBTReader.skipWhitespace(reader);
            reader.mark(1);
            if (SNBTReader.readChar(reader) == 93) break;
            reader.reset();
            Object value = SNBTReader.readLiteral(reader, internValues);
            if (!(arrayType == TagType.BYTE_ARRAY && value instanceof Byte || arrayType == TagType.INT_ARRAY && value instanceof Integer || arrayType == TagType.LONG_ARRAY && value instanceof Long)) {
                throw new NBTParseException("Mismatch between SNBT array and element types");
            }
            values.add(value);
            SNBTReader.skipWhitespace(reader);
        } while (SNBTReader.readChar(reader) == 44);
        Object result = Array.newInstance(arrayType.getRuntimeType().getComponentType(), values.size());
        for (int i = 0; i < values.size(); ++i) {
            Array.set(result, i, values.get(i));
        }
        return result;
    }

    private static NBTList readList(Reader reader, boolean internNames, boolean internValues) throws IOException {
        if (SNBTReader.readChar(reader) != 91) {
            throw new NBTParseException("Invalid start of SNBT list");
        }
        NBTList list = null;
        do {
            SNBTReader.skipWhitespace(reader);
            reader.mark(1);
            if (SNBTReader.readChar(reader) == 93) {
                if (list != null) break;
                return new NBTList(TagType.END);
            }
            reader.reset();
            Object entry = SNBTReader.read(reader, internNames, internValues);
            if (list == null && (list = new NBTList(TagType.fromObject(entry))).getContentType() == TagType.END) {
                throw new NBTParseException("SNBT list entry has unrecognized type");
            }
            list.add(entry);
        } while (SNBTReader.readChar(reader) == 44);
        return list;
    }

    private static Object readLiteral(Reader reader, boolean intern) throws IOException {
        int firstChar = SNBTReader.peekChar(reader);
        boolean isQuoted = firstChar == 34 || firstChar == 39;
        String asString = SNBTReader.readString(reader, false);
        if (isQuoted) {
            return asString;
        }
        String withoutSuffix = asString.replaceFirst(LITERAL_SUFFIX_PATTERN, "");
        if (asString.matches(INT_PATTERN)) {
            return Integer.parseInt(withoutSuffix);
        }
        if (asString.matches(DOUBLE_PATTERN)) {
            return Double.parseDouble(withoutSuffix);
        }
        if (asString.matches(BYTE_PATTERN)) {
            return Byte.parseByte(withoutSuffix);
        }
        if (asString.matches(SHORT_PATTERN)) {
            return Short.parseShort(withoutSuffix);
        }
        if (asString.matches(LONG_PATTERN)) {
            return Long.parseLong(withoutSuffix);
        }
        if (asString.matches(FLOAT_PATTERN)) {
            return Float.valueOf(Float.parseFloat(withoutSuffix));
        }
        if (intern) {
            return asString.intern();
        }
        return asString;
    }

    private static String readString(Reader reader, boolean intern) throws IOException {
        StringBuilder valueBuilder = new StringBuilder();
        int firstChar = reader.read();
        if (firstChar == 34 || firstChar == 39) {
            int lastChar;
            boolean isEscaped = false;
            while ((lastChar = reader.read()) != firstChar || isEscaped) {
                valueBuilder.append((char)lastChar);
                isEscaped = lastChar == 92;
            }
        } else {
            int lastChar;
            valueBuilder.append((char)firstChar);
            reader.mark(1);
            while (VALID_UNQUOTED_CHARS.indexOf(lastChar = reader.read()) != -1) {
                valueBuilder.append((char)lastChar);
                reader.mark(1);
            }
            reader.reset();
        }
        String value = valueBuilder.toString();
        if (firstChar != 34 && firstChar != 39) {
            value = value.trim();
        }
        if (intern) {
            return value.intern();
        }
        return value;
    }

    private static void skipWhitespace(Reader reader) throws IOException {
        do {
            reader.mark(1);
        } while (Character.isWhitespace(reader.read()));
        reader.reset();
    }

    private static int peekChar(Reader reader) throws IOException {
        reader.mark(1);
        int value = reader.read();
        reader.reset();
        if (value == -1) {
            throw new IOException("Unexpected end of SNBT string");
        }
        return value;
    }

    private static int readChar(Reader reader) throws IOException {
        int value = reader.read();
        if (value == -1) {
            throw new IOException("Unexpected end of SNBT string");
        }
        return value;
    }

    private SNBTReader() {
        throw new UnsupportedOperationException("SNBTReader should not be instantiated");
    }
}

