/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit.filter;

import java.io.IOException;
import java.io.InputStream;
import me.nullicorn.nedit.NBTInputStream;
import me.nullicorn.nedit.exception.NBTParseException;
import me.nullicorn.nedit.filter.FilterMode;
import me.nullicorn.nedit.filter.FilteredTag;
import me.nullicorn.nedit.filter.NBTFilter;
import me.nullicorn.nedit.type.NBTCompound;
import me.nullicorn.nedit.type.NBTList;
import me.nullicorn.nedit.type.TagType;

public class FilteredNBTInputStream
extends NBTInputStream {
    public FilteredNBTInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public FilteredNBTInputStream(InputStream inputStream, boolean internNames, boolean internValues) {
        super(inputStream, internNames, internValues);
    }

    public NBTCompound readFully(NBTFilter filter) throws IOException {
        this.gunzipIfNecessary();
        TagType rootType = this.readTagId();
        if (rootType == TagType.END) {
            return new NBTCompound();
        }
        if (rootType != TagType.COMPOUND) {
            throw new IOException("Expected COMPOUND at NBT root, but got " + (Object)((Object)rootType));
        }
        this.readString();
        return this.readCompound(filter, 0);
    }

    private NBTCompound readCompound(NBTFilter filter, int depth) throws IOException {
        NBTCompound result = new NBTCompound();
        boolean reachedEnd = false;
        while (!reachedEnd) {
            TagType tagType = this.readTagId();
            if (tagType == null) {
                throw new NBTParseException("Unknown tag ID for TAG_Compound");
            }
            if (tagType == TagType.END) {
                reachedEnd = true;
                continue;
            }
            String tagName = this.readString(this.internNames);
            boolean continueReading = filter.getMode() == FilterMode.EXCLUDE;
            FilteredTag match = null;
            for (FilteredTag filtered : filter) {
                String[] tokens = filtered.getTokens();
                boolean matches = depth < tokens.length && tagName.equals(tokens[depth]);
                if (!matches) continue;
                continueReading = filter.getMode() == FilterMode.INCLUDE || depth + 1 < tokens.length;
                match = filtered;
                break;
            }
            if (continueReading) {
                int childDepth = depth + 1;
                NBTFilter subFilter = match == null ? null : filter.subFilter(match, childDepth);
                Object value = subFilter == null || subFilter.isEmpty() ? this.readValue(tagType) : this.readValue(tagType, subFilter, childDepth);
                result.put(tagName, value);
                continue;
            }
            this.skipValue(tagType);
        }
        return result;
    }

    private NBTList readList(NBTFilter filter, int depth) throws IOException {
        TagType contentType = this.readTagId();
        int length = this.readInt();
        if (contentType == null) {
            throw new NBTParseException("Unknown tag ID for TAG_List");
        }
        if (length == 0) {
            return new NBTList(contentType);
        }
        if (length < 0) {
            throw new NBTParseException(new NegativeArraySizeException());
        }
        NBTList list = new NBTList(contentType);
        for (int i = 0; i < length; ++i) {
            list.add(this.readValue(contentType, filter, depth));
        }
        return list;
    }

    private Object readValue(TagType type, NBTFilter filter, int depth) throws IOException {
        if (type == TagType.COMPOUND) {
            return this.readCompound(filter, depth);
        }
        if (type == TagType.LIST) {
            return this.readList(filter, depth);
        }
        return this.readValue(type);
    }

    private void skipValue(TagType type) throws IOException {
        int bytesToSkip;
        switch (type) {
            case LIST: {
                TagType elementType = this.readTagId();
                int length = this.readInt();
                if (elementType != TagType.END) {
                    for (int i = 0; i < length; ++i) {
                        this.skipValue(elementType);
                    }
                }
                return;
            }
            case COMPOUND: {
                TagType childType;
                while ((childType = this.readTagId()) != TagType.END) {
                    this.skipString();
                    this.skipValue(childType);
                }
                return;
            }
            case STRING: {
                this.skipString();
                return;
            }
            case BYTE: {
                bytesToSkip = 1;
                break;
            }
            case SHORT: {
                bytesToSkip = 2;
                break;
            }
            case FLOAT: 
            case INT: {
                bytesToSkip = 4;
                break;
            }
            case LONG: 
            case DOUBLE: {
                bytesToSkip = 8;
                break;
            }
            case BYTE_ARRAY: {
                bytesToSkip = this.readInt();
                break;
            }
            case INT_ARRAY: {
                bytesToSkip = this.readInt() * 4;
                break;
            }
            case LONG_ARRAY: {
                bytesToSkip = this.readInt() * 8;
                break;
            }
            default: {
                return;
            }
        }
        this.skipBytes(bytesToSkip);
    }

    private void skipString() throws IOException {
        int length = this.readUnsignedShort();
        this.skipBytes(length);
    }
}

