/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit.filter;

import java.util.Objects;

public class FilteredTag {
    private final String name;
    private final String[] tokens;

    public static String[] tokenizeTagName(String name) {
        String[] tokens = name.split("(?<!\\\\)\\.");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].replace("\\.", ".");
        }
        return tokens;
    }

    public FilteredTag(String name) {
        if (name == null) {
            throw new NullPointerException("Filtered tag name cannot be null");
        }
        this.name = name;
        this.tokens = FilteredTag.tokenizeTagName(name);
    }

    public String getName() {
        return this.name;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public boolean isExtendedBy(FilteredTag other, int depth) {
        if (this.tokens.length <= depth || other.tokens.length <= depth || other.equals(this)) {
            return false;
        }
        for (int i = 0; i < depth; ++i) {
            if (other.tokens[i].equals(this.tokens[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isExtendedBy(FilteredTag other) {
        String otherName = other.getName();
        int extensionIndex = this.name.length();
        return otherName.length() > extensionIndex && otherName.charAt(extensionIndex) == '.' && otherName.charAt(extensionIndex - 1) != '\\' && otherName.startsWith(this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredTag that = (FilteredTag)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

