/*
 * Decompiled with CFR 0.152.
 */
package me.nullicorn.nedit.type;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import me.nullicorn.nedit.filter.FilteredTag;
import me.nullicorn.nedit.type.NBTList;
import me.nullicorn.nedit.type.TagType;

public class NBTCompound
extends AbstractMap<String, Object> {
    private final Map<String, Object> decorated = new HashMap<String, Object>();

    public boolean containsTag(String name, TagType type) {
        Objects.requireNonNull(name, "Tag name cannot be null");
        Objects.requireNonNull(type, "Tag type cannot be null");
        Object value = this.get(name);
        return value != null && TagType.fromObject(value) == type;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value, "value cannot be null");
        return this.decorated.containsValue(value);
    }

    public double getDouble(String name, double defaultValue) {
        return this.getNumber(name, defaultValue).doubleValue();
    }

    public float getFloat(String name, float defaultValue) {
        return this.getNumber(name, Float.valueOf(defaultValue)).floatValue();
    }

    public short getShort(String name, short defaultValue) {
        return this.getNumber(name, defaultValue).shortValue();
    }

    public long getLong(String name, long defaultValue) {
        return this.getNumber(name, defaultValue).longValue();
    }

    public int getInt(String name, int defaultValue) {
        return this.getNumber(name, defaultValue).intValue();
    }

    public byte getByte(String name, byte defaultValue) {
        return this.getNumber(name, defaultValue).byteValue();
    }

    public Number getNumber(String name, Number defaultValue) {
        Object result = this.get(name);
        return result instanceof Number ? (Number)((Number)result) : (Number)defaultValue;
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        Object result = this.get(name);
        return result != null ? result.toString() : defaultValue;
    }

    public long[] getLongArray(String name) {
        Object result = this.get(name);
        return result instanceof long[] ? (long[])result : null;
    }

    public int[] getIntArray(String name) {
        Object result = this.get(name);
        return result instanceof int[] ? (int[])result : null;
    }

    public byte[] getByteArray(String name) {
        Object result = this.get(name);
        return result instanceof byte[] ? (byte[])result : null;
    }

    public NBTList getList(String name) {
        Object result = this.get(name);
        return result instanceof NBTList ? (NBTList)result : null;
    }

    public NBTCompound getCompound(String name) {
        Object result = this.get(name);
        return result instanceof NBTCompound ? (NBTCompound)result : null;
    }

    @Override
    public Object get(Object name) {
        Objects.requireNonNull(name, "Tag name cannot be null");
        if (!(name instanceof String)) {
            throw new ClassCastException("Tag name must be java.lang.String");
        }
        String[] tokens = FilteredTag.tokenizeTagName((String)name);
        if (tokens.length == 1) {
            return this.decorated.get(name);
        }
        NBTCompound parent = this;
        for (int i = 0; i < tokens.length; ++i) {
            Object child = parent.decorated.get(tokens[i]);
            if (i + 1 == tokens.length) {
                return child;
            }
            if (!(child instanceof NBTCompound)) break;
            parent = (NBTCompound)child;
        }
        return null;
    }

    @Override
    public Object put(String name, Object value) {
        this.checkTag(name, value);
        return this.decorated.put(name, value);
    }

    @Override
    public Object putIfAbsent(String name, Object value) {
        this.checkTag(name, value);
        return this.decorated.putIfAbsent(name, value);
    }

    @Override
    public boolean remove(Object name, Object value) {
        return this.decorated.remove(name, value);
    }

    @Override
    public Object remove(Object name) {
        return this.decorated.remove(name);
    }

    @Override
    public void clear() {
        this.decorated.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.decorated.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.decorated.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.decorated.entrySet();
    }

    @Override
    public int size() {
        return this.decorated.size();
    }

    private void checkTag(String name, Object value) {
        String message = null;
        Function<String, RuntimeException> exception = null;
        if (name == null) {
            message = "Compounds cannot have null tag names (value=" + value + ")";
            exception = NullPointerException::new;
        } else if (value == null) {
            message = "Compounds cannot have null tag values (name=" + name + ")";
            exception = NullPointerException::new;
        } else if (TagType.END == TagType.fromObject(value)) {
            message = "TAG_End cannot be used as a value (name=" + name + ",value=" + value + ")";
            exception = IllegalArgumentException::new;
        }
        if (message != null) {
            throw (RuntimeException)exception.apply(message);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        for (Map.Entry<String, Object> tag : this.decorated.entrySet()) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(tag.getKey().isEmpty() ? "\"\"" : tag.getKey());
            sb.append(":");
            sb.append(NBTCompound.tagToString(tag.getValue()));
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    private static String tagToString(Object value) {
        TagType tagType = TagType.fromObject(value);
        switch (tagType) {
            case BYTE: {
                return NBTCompound.byteToString((Byte)value);
            }
            case SHORT: {
                return NBTCompound.shortToString((Short)value);
            }
            case INT: {
                return NBTCompound.intToString((Integer)value);
            }
            case LONG: {
                return NBTCompound.longToString((Long)value);
            }
            case FLOAT: {
                return NBTCompound.floatToString(((Float)value).floatValue());
            }
            case DOUBLE: {
                return NBTCompound.doubleToString((Double)value);
            }
            case BYTE_ARRAY: {
                return NBTCompound.byteArrayToString((byte[])value);
            }
            case STRING: {
                return NBTCompound.stringTagToString((String)value);
            }
            case LIST: {
                return NBTCompound.listToString((NBTList)value);
            }
            case COMPOUND: {
                return value.toString();
            }
            case INT_ARRAY: {
                return NBTCompound.intArrayToString((int[])value);
            }
            case LONG_ARRAY: {
                return NBTCompound.longArrayToString((long[])value);
            }
        }
        return "";
    }

    private static String byteToString(byte value) {
        return value + "b";
    }

    private static String shortToString(short value) {
        return value + "s";
    }

    private static String intToString(int value) {
        return Integer.toString(value);
    }

    private static String longToString(long value) {
        return value + "l";
    }

    private static String floatToString(float value) {
        return value + "f";
    }

    private static String doubleToString(double value) {
        return value + "d";
    }

    private static String byteArrayToString(byte[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append("[B;");
        for (int i = 0; i < value.length; ++i) {
            sb.append(value[i]);
            if (i >= value.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String stringTagToString(String value) {
        return "\"" + value + "\"";
    }

    private static String listToString(NBTList value) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < value.size(); ++i) {
            sb.append(value.get(i) != null ? NBTCompound.tagToString(value.get(i)) : Integer.valueOf(0));
            if (i >= value.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String intArrayToString(int[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append("[I;");
        for (int i = 0; i < value.length; ++i) {
            sb.append(value[i]);
            if (i >= value.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String longArrayToString(long[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append("[L;");
        for (int i = 0; i < value.length; ++i) {
            sb.append(value[i]);
            if (i >= value.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NBTCompound)) {
            return false;
        }
        NBTCompound c = (NBTCompound)o;
        if (c.size() != this.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.decorated.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object oValue = c.get(key);
            if (!(value == null ? oValue != null || !c.containsKey(key) : !Objects.deepEquals(value, oValue))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<String, Object> entry : this.decorated.entrySet()) {
            Object value = entry.getValue();
            int valHash = value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : value.hashCode()));
            hashCode += Objects.hashCode(entry.getKey()) ^ valHash;
        }
        return hashCode;
    }
}

