/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.client;

import fuzs.armorstatues.client.gui.screens.armorstand.ArmorStandAlignmentsScreen;
import fuzs.armorstatues.client.gui.screens.armorstand.ArmorStandPositionScreen;
import fuzs.armorstatues.client.gui.screens.armorstand.ArmorStandVanillaTweaksScreen;
import fuzs.armorstatues.client.handler.ClientInteractHandler;
import fuzs.armorstatues.client.handler.DataSyncTickHandler;
import fuzs.armorstatues.init.ModRegistry;
import fuzs.armorstatues.world.inventory.data.ArmorStandScreenTypes;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.InteractionInputEvents;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ItemTooltipRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.statuemenus.api.v1.client.gui.screens.StatueScreenFactory;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.inventory.StatueMenu;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Items;

public class ArmorStatuesClient
implements ClientModConstructor {
    public void onConstructMod() {
        ArmorStatuesClient.registerEventHandlers();
        ItemTooltipRegistry.ITEM.registerItemTooltip((Object)Items.ARMOR_STAND, ArmorStandInteractHelper.getArmorStandHoverText());
    }

    private static void registerEventHandlers() {
        ClientTickEvents.END.register(DataSyncTickHandler::onEndClientTick);
        ScreenEvents.remove(Screen.class).register(DataSyncTickHandler::onRemove);
        InteractionInputEvents.USE.register(EventPhase.BEFORE, ClientInteractHandler::onUseInteraction);
    }

    public void onClientSetup() {
        StatueScreenFactory.register((StatueScreenType)ArmorStandScreenTypes.POSITION, ArmorStandPositionScreen::new);
        StatueScreenFactory.register((StatueScreenType)ArmorStandScreenTypes.ALIGNMENTS, ArmorStandAlignmentsScreen::new);
        StatueScreenFactory.register((StatueScreenType)ArmorStandScreenTypes.VANILLA_TWEAKS, ArmorStandVanillaTweaksScreen::new);
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.ARMOR_STAND_MENU_TYPE.value(), (menu, inventory, component) -> StatueScreenFactory.createLastScreenType((StatueMenu)menu, (Inventory)inventory, (Component)component));
    }
}

