/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.network.client.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.DynamicOps;
import fuzs.armorstatues.ArmorStatues;
import fuzs.armorstatues.config.ClientConfig;
import fuzs.statuemenus.api.v1.helper.ScaleAttributeHelper;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.entity.decoration.StatueEntity;
import fuzs.statuemenus.api.v1.world.inventory.StatueHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueAlignment;
import fuzs.statuemenus.api.v1.world.inventory.data.StatuePose;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueStyleOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;

public class CommandDataSyncHandler
implements DataSyncHandler {
    public static final String FINISHED_TRANSLATION_KEY = ArmorStatues.id("finished").toLanguageKey("data_sync");
    public static final String FAILURE_TRANSLATION_KEY = ArmorStatues.id("failure").toLanguageKey("data_sync");
    public static final String NO_PERMISSION_TRANSLATION_KEY = ArmorStatues.id("failure").toLanguageKey("data_sync", "no_permission");
    public static final String NO_ARMOR_STAND_TRANSLATION_KEY = ArmorStatues.id("failure").toLanguageKey("data_sync", "no_armor_stand");
    public static final String OUT_OF_RANGE_TRANSLATION_KEY = ArmorStatues.id("failure").toLanguageKey("data_sync", "out_of_range");
    public static final String NOT_FINISHED_TRANSLATION_KEY = ArmorStatues.id("failure").toLanguageKey("data_sync", "not_finished");
    private static final Queue<List<String>> CLIENT_COMMAND_QUEUE = new ArrayDeque<List<String>>();
    @Nullable
    private static LivingEntity queueArmorStand;
    private static int itemDequeuedTicks;
    private final StatueHolder holder;
    protected final LocalPlayer player;
    protected StatuePose lastSyncedPose;

    public CommandDataSyncHandler(StatueHolder holder, LocalPlayer player) {
        this.holder = holder;
        this.lastSyncedPose = StatuePose.fromEntity((StatueEntity)this.holder.getStatueEntity());
        this.player = player;
    }

    public StatueHolder getArmorStandHolder() {
        return this.holder;
    }

    public void sendName(String name) {
        if (!this.isEditingAllowed()) {
            return;
        }
        DataSyncHandler.setCustomArmorStandName((LivingEntity)this.getEntity(), (String)name);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.storeNullable("CustomName", ComponentSerialization.CODEC, (DynamicOps)this.player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)Component.literal((String)name));
        this.enqueueEntityData(compoundTag);
        this.finalizeCurrentOperation();
    }

    public void sendPose(StatuePose pose, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.sendPosePart((arg_0, arg_1) -> ((StatuePose)pose).serializeBodyPoses(arg_0, arg_1), this.lastSyncedPose);
        this.sendPosePart((arg_0, arg_1) -> ((StatuePose)pose).serializeArmPoses(arg_0, arg_1), this.lastSyncedPose);
        this.sendPosePart((arg_0, arg_1) -> ((StatuePose)pose).serializeLegPoses(arg_0, arg_1), this.lastSyncedPose);
        pose.applyToEntity(this.getArmorStandHolder().getStatueEntity());
        this.lastSyncedPose = pose.copyAndFillFrom(this.lastSyncedPose);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private void sendPosePart(BiConsumer<CompoundTag, StatuePose> dataWriter, StatuePose lastSyncedPose) {
        CompoundTag compoundTag = new CompoundTag();
        dataWriter.accept(compoundTag, lastSyncedPose);
        if (!compoundTag.isEmpty()) {
            CompoundTag tagToSend = new CompoundTag();
            tagToSend.put("Pose", (Tag)compoundTag);
            this.enqueueEntityData(tagToSend);
        }
    }

    @Nullable
    public StatuePose getLastSyncedPose() {
        return this.lastSyncedPose;
    }

    public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        ListTag listTag = new ListTag();
        listTag.add((Object)DoubleTag.valueOf((double)posX));
        listTag.add((Object)DoubleTag.valueOf((double)posY));
        listTag.add((Object)DoubleTag.valueOf((double)posZ));
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("Pos", (Tag)listTag);
        this.enqueueEntityData(compoundTag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendScale(float scale, boolean finalize) {
        this.sendScale(true, scale, finalize);
    }

    public void sendScale(boolean hasModifier, float scale, boolean finalize) {
        ArrayList<String> clientCommands = new ArrayList<String>();
        if (hasModifier) {
            clientCommands.add("attribute %s %s modifier remove %s".formatted(this.getEntity().getStringUUID(), ((ResourceKey)Attributes.SCALE.unwrapKey().orElseThrow()).location(), ScaleAttributeHelper.SCALE_BONUS_ID));
        }
        if (scale != ScaleAttributeHelper.DEFAULT_SCALE) {
            clientCommands.add("attribute %s %s modifier add %s %s add_value".formatted(this.getEntity().getStringUUID(), ((ResourceKey)Attributes.SCALE.unwrapKey().orElseThrow()).location(), ScaleAttributeHelper.SCALE_BONUS_ID, Float.valueOf(scale - ScaleAttributeHelper.DEFAULT_SCALE)));
        }
        this.enqueueClientCommand(clientCommands);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendRotation(float rotation, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)rotation));
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("Rotation", (Tag)listTag);
        this.enqueueEntityData(compoundTag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendStyleOption(StatueStyleOption<?> styleOption, boolean value, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        CompoundTag compoundTag = new CompoundTag();
        styleOption.toTag(compoundTag, value);
        this.enqueueEntityData(compoundTag);
        styleOption.setOption(this.getEntity(), value);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    public void sendAlignment(StatueAlignment alignment) {
        if (!this.isEditingAllowed()) {
            return;
        }
        super.sendAlignment(alignment);
    }

    public boolean supportsScreenType(StatueScreenType screenType) {
        return !screenType.requiresServer();
    }

    public void tick() {
        if (itemDequeuedTicks > 0) {
            --itemDequeuedTicks;
        }
        if (itemDequeuedTicks == 0 && queueArmorStand != null && !CLIENT_COMMAND_QUEUE.isEmpty()) {
            if (this.testArmorStand(queueArmorStand).right().isPresent()) {
                for (String clientCommand : CLIENT_COMMAND_QUEUE.poll()) {
                    this.player.connection.sendCommand(clientCommand);
                }
            } else {
                CLIENT_COMMAND_QUEUE.clear();
            }
            itemDequeuedTicks = this.getDequeueDelayTicks();
        } else if (itemDequeuedTicks == 1 && CLIENT_COMMAND_QUEUE.isEmpty()) {
            this.sendDisplayMessage((Component)Component.translatable((String)FINISHED_TRANSLATION_KEY), false);
        }
    }

    protected int getDequeueDelayTicks() {
        return 5;
    }

    public boolean shouldContinueTicking() {
        return !CLIENT_COMMAND_QUEUE.isEmpty() || itemDequeuedTicks != 0;
    }

    protected boolean isEditingAllowed() {
        return this.isEditingAllowed(!((ClientConfig)ArmorStatues.CONFIG.get(ClientConfig.class)).overrideClientPermissionsCheck);
    }

    protected final boolean isEditingAllowed(boolean testPermissionLevel) {
        if (testPermissionLevel && !this.player.hasPermissions(2)) {
            this.sendFailureMessage((Component)Component.translatable((String)NO_PERMISSION_TRANSLATION_KEY));
            return false;
        }
        return this.player.getAbilities().mayBuild && this.testArmorStand(this.getEntity()).ifLeft(this::sendFailureMessage).right().isPresent();
    }

    protected Either<Component, Unit> testArmorStand(LivingEntity livingEntity) {
        return !livingEntity.isAlive() ? Either.left((Object)Component.translatable((String)NO_ARMOR_STAND_TRANSLATION_KEY)) : Either.right((Object)Unit.INSTANCE);
    }

    protected boolean enqueueClientCommand(String clientCommand) {
        return this.enqueueClientCommand(Collections.singletonList(clientCommand));
    }

    protected boolean enqueueClientCommand(List<String> clientCommand) {
        if (CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = null;
        } else if (queueArmorStand != null) {
            this.sendFailureMessage((Component)Component.translatable((String)NOT_FINISHED_TRANSLATION_KEY));
            return false;
        }
        CLIENT_COMMAND_QUEUE.offer(clientCommand);
        return true;
    }

    public void finalizeCurrentOperation() {
        if (!CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = this.getEntity();
        }
    }

    protected void sendFailureMessage(Component component) {
        this.sendDisplayMessage((Component)Component.translatable((String)FAILURE_TRANSLATION_KEY, (Object[])new Object[]{component}), true);
    }

    protected void sendDisplayMessage(Component component, boolean failure) {
        this.player.displayClientMessage((Component)Component.empty().append(component).withStyle(failure ? ChatFormatting.RED : ChatFormatting.GREEN), false);
    }

    private void enqueueEntityData(CompoundTag compoundTag) {
        this.enqueueClientCommand("data merge entity %s %s".formatted(this.getEntity().getStringUUID(), compoundTag));
    }
}

