/*
 * Decompiled with CFR 0.152.
 */
package dev.rit3776.craftingtablepy;

import dev.rit3776.craftingtablepy.EventRegistry;
import dev.rit3776.craftingtablepy.PythonBridge;
import dev.rit3776.craftingtablepy.PythonEventScanner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTablepy
implements ModInitializer {
    public static final String MOD_ID = "craftingtablepy";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"craftingtablepy");
    private static PythonBridge pythonBridge;

    public void onInitialize() {
        LOGGER.info("[CraftingTable.py] Checking Python files...");
        CraftingTablepy.ensureUserScriptExists();
        LOGGER.info("[CraftingTable.py] Initializing...");
        pythonBridge = new PythonBridge();
        pythonBridge.start();
        List<String> detected = PythonEventScanner.scanEvents();
        EventRegistry.registerDetectedEvents(detected, pythonBridge);
        LOGGER.info("[CraftingTable.py] Initialized successfully!");
    }

    private static void ensureUserScriptExists() {
        block21: {
            Path configDir = Paths.get("config/craftingtablepy", new String[0]);
            Path coreFile = configDir.resolve("craftingtable.py");
            Path modFile = configDir.resolve("mod.py");
            try {
                InputStream is;
                if (!Files.exists(configDir, new LinkOption[0])) {
                    Files.createDirectories(configDir, new FileAttribute[0]);
                }
                if (!Files.exists(coreFile, new LinkOption[0])) {
                    is = CraftingTablepy.class.getClassLoader().getResourceAsStream("craftingtablepy/craftingtable.py");
                    try {
                        if (is == null) {
                            LOGGER.error("[CraftingTable.py] Default craftingtable.py not found in resources!");
                            return;
                        }
                        Files.copy(is, coreFile, new CopyOption[0]);
                        LOGGER.info("[CraftingTable.py] Generated default craftingtable.py in config directory.");
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                if (Files.exists(modFile, new LinkOption[0])) break block21;
                is = CraftingTablepy.class.getClassLoader().getResourceAsStream("craftingtablepy/mod.py");
                try {
                    if (is == null) {
                        LOGGER.error("[CraftingTable.py] Default mod.py not found in resources!");
                        return;
                    }
                    Files.copy(is, modFile, new CopyOption[0]);
                    LOGGER.info("[CraftingTable.py] Generated default mod.py in config directory.");
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("[CraftingTable.py] Failed to copy default Python files.", (Throwable)e);
            }
        }
    }

    public static PythonBridge getBridge() {
        return pythonBridge;
    }
}

