/*
 * Decompiled with CFR 0.152.
 */
package dev.rit3776.craftingtablepy;

import com.google.gson.Gson;
import dev.rit3776.craftingtablepy.CraftingTablepy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;

public class PythonBridge {
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private PrintWriter out;
    private BufferedReader in;
    private Process pythonProcess;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private MinecraftServer server;

    public PythonBridge() {
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            this.server = s;
            CraftingTablepy.LOGGER.info("[CraftingTable.py] MinecraftServer registered in PythonBridge.");
        });
    }

    public void start() {
        this.startPythonProcess();
        this.executor.submit(() -> {
            try {
                String line;
                this.serverSocket = new ServerSocket(52577, 0, InetAddress.getByName("127.0.0.1"));
                CraftingTablepy.LOGGER.info("[CraftingTable.py] Waiting for Python connection...");
                this.clientSocket = this.serverSocket.accept();
                CraftingTablepy.LOGGER.info("[CraftingTable.py] Python connected.");
                this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                while ((line = this.in.readLine()) != null) {
                    if (line.startsWith("CMD:")) {
                        String cmd = line.substring(4);
                        CraftingTablepy.LOGGER.info("[Python->MC CMD] " + cmd);
                        this.executeMinecraftCommand(cmd);
                        continue;
                    }
                    if (line.startsWith("LOG:")) {
                        String msg = line.substring(4);
                        CraftingTablepy.LOGGER.info("[Python->MC LOG] " + msg);
                        continue;
                    }
                    CraftingTablepy.LOGGER.warn("[Python->MC Unknown] " + line);
                }
            }
            catch (IOException e) {
                CraftingTablepy.LOGGER.error("Error in PythonBridge: ", (Throwable)e);
            }
        });
    }

    private void startPythonProcess() {
        try {
            File scriptFile = new File("config/craftingtablepy/craftingtable.py");
            if (!scriptFile.exists()) {
                CraftingTablepy.LOGGER.error("[CraftingTable.py] Python script not found: " + scriptFile.getAbsolutePath());
                return;
            }
            ProcessBuilder pb = new ProcessBuilder("python", scriptFile.getAbsolutePath());
            pb.redirectErrorStream(true);
            this.pythonProcess = pb.start();
            new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.pythonProcess.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        CraftingTablepy.LOGGER.info("[Python] " + line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }).start();
            CraftingTablepy.LOGGER.info("[CraftingTable.py] Python process started: " + scriptFile.getAbsolutePath());
        }
        catch (IOException e) {
            CraftingTablepy.LOGGER.error("[CraftingTable.py] Failed to start Python process", (Throwable)e);
        }
    }

    private void executeMinecraftCommand(String command) {
        if (this.server == null) {
            CraftingTablepy.LOGGER.warn("[CraftingTable.py] Command skipped: server not ready yet -> " + command);
            return;
        }
        this.server.execute(() -> this.server.method_3734().method_44252(this.server.method_3739().method_9206(4), command));
    }

    public void sendEvent(String eventName, Map<String, Object> data) {
        if (this.out != null) {
            Map<String, Map<String, Object>> payload = Map.of("type", "event", "name", eventName, "data", data);
            String json = new Gson().toJson(payload);
            this.out.println(json);
        }
    }
}

