/*
 * Decompiled with CFR 0.152.
 */
package dev.rit3776.craftingtablepy;

import dev.rit3776.craftingtablepy.CraftingTablepy;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class PythonEventScanner {
    private static final Logger LOGGER = CraftingTablepy.LOGGER;
    private static final String[] EVENTS = new String[]{"on_player_join", "on_player_leave", "on_chat", "on_item_use"};

    public static List<String> scanEvents() {
        ArrayList<String> detected = new ArrayList<String>();
        Path path = Paths.get("config/craftingtablepy/mod.py", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("[CraftingTable.py] mod.py not found.");
            return detected;
        }
        try {
            String content = Files.readString(path);
            for (String ev : EVENTS) {
                if (!content.contains("def " + ev)) continue;
                detected.add(ev);
                LOGGER.info("[CraftingTable.py] Detected event: " + ev);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read mod.py", (Throwable)e);
        }
        return detected;
    }
}

