/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.api;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class TagUtilities<T> {
    private final String modId;
    private final ResourceKey<? extends Registry<T>> resourceKey;

    private TagUtilities(String modId, ResourceKey<? extends Registry<T>> resourceKey) {
        this.modId = modId;
        this.resourceKey = resourceKey;
    }

    public static <T> TagUtilities<T> create(String modId, ResourceKey<? extends Registry<T>> resourceKey) {
        return new TagUtilities<T>(modId, resourceKey);
    }

    public TagKey<T> mcTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    public TagKey<T> commonTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    public TagKey<T> modTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name));
    }

    public TagKey<T> configTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)name));
    }

    public TagKey<T> forgeTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
    }

    public TagKey<T> neoforgeTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)name));
    }

    public TagKey<T> fabricTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fabric", (String)name));
    }

    public TagKey<T> quiltTag(String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quilt", (String)name));
    }

    public TagKey<T> customTag(String modId, String name) {
        return TagKey.create(this.resourceKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
    }
}

