/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi;

import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.config.ConfigEvents;
import com.craftjakob.configapi.config.ConfigTracker;
import com.craftjakob.configapi.config.network.ConfigNetwork;
import com.craftjakob.configapi.config.network.ConfigPacketPayload;
import com.craftjakob.event.EventPriority;
import com.craftjakob.event.events.common.LifecycleEvent;
import com.craftjakob.event.events.common.PlayerEvent;
import com.craftjakob.network.NetworkManager;
import com.craftjakob.network.PlayNetworking;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public final class ConfigAPI {
    public static final String FILE_FORMAT = "cfg";
    public static final Logger LOGGER = LogUtils.getLogger();

    private ConfigAPI() {
    }

    public static void registerCommon() {
        NetworkManager.playS2C(ConfigPacketPayload.TYPE, ConfigPacketPayload.CODEC, (payload, context) -> context.queue(() -> ConfigNetwork.acceptSyncedConfigs(payload.getFilePath(), payload.getContents())));
        LifecycleEvent.SERVER_BEFORE_START.priority(EventPriority.HIGH).register(ConfigEvents::onServerLoad);
        LifecycleEvent.SERVER_STOPPED.priority(EventPriority.LOW).register(server -> ConfigEvents.onUnloadServer());
        PlayerEvent.JOIN.priority(EventPriority.HIGH).register(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                List<ConfigPacketPayload> configData = ConfigNetwork.getConfigSync();
                if (!configData.isEmpty()) {
                    for (ConfigPacketPayload payload : configData) {
                        PlayNetworking.sendToPlayer(serverPlayer, payload);
                    }
                }
            }
        });
        LifecycleEvent.SERVER_RELOAD.register(server -> {
            ConfigTracker.get().reload(Config.ConfigType.SERVER);
            List<ConfigPacketPayload> configData = ConfigNetwork.getConfigSync();
            if (!configData.isEmpty()) {
                for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
                    for (ConfigPacketPayload payload : configData) {
                        PlayNetworking.sendToPlayer(serverPlayer, payload);
                    }
                }
            }
        });
    }
}

