/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen;

import com.craftjakob.configapi.client.ConfigScreenUtils;
import com.craftjakob.configapi.client.screen.EnumConfigScreen;
import com.craftjakob.configapi.client.screen.ModScreen;
import com.craftjakob.configapi.client.screen.list.ModObjectSelectionList;
import com.craftjakob.configapi.config.ConfigValueTypes;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class EnumConfigScreen<E extends Enum<E>>
extends ModScreen {
    public final Component subtitle;
    private final ConfigValueTypes.ConfigValue<Enum<E>> config;
    private Enum<?> value;
    private final Enum<?>[] values;
    private final Consumer<Enum<?>> onDone;
    public EnumList list;
    private Button doneButton;
    private Button cancelButton;
    private Button resetButton;

    public EnumConfigScreen(ModScreen lastScreen, ConfigValueTypes.ConfigValue<Enum<E>> config, Consumer<Enum<?>> onDone) {
        super(lastScreen, (Component)Component.literal((String)config.getKey()), lastScreen.getLogoLocation());
        this.config = config;
        this.onDone = onDone;
        this.subtitle = Component.literal((String)config.getComments().stream().filter(comment -> !comment.startsWith("Allowed Values: ")).collect(Collectors.joining(", ")));
        this.value = config.getValue();
        this.values = (Enum[])config.getDefaultValue().getDeclaringClass().getEnumConstants();
    }

    @Override
    protected void init() {
        this.list = new EnumList(25);
        this.addWidget((GuiEventListener)this.list);
        this.list.setSelected((AbstractSelectionList.Entry)((EnumList.Entry)this.list.children().stream().filter(entry -> entry.value == this.value).findFirst().orElse(null)));
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.onDone.accept(this.value);
            this.onClose();
        }).bounds(this.width / 2, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.doneButton);
        this.cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 150, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.cancelButton);
        this.resetButton = ConfigScreenUtils.createIconResetButton(this.width / 2 + 150, this.height - 27, button -> {
            this.value = this.config.getDefaultValue();
            this.list.setSelected((AbstractSelectionList.Entry)((EnumList.Entry)this.list.children().stream().filter(entry -> entry.value == this.config.getDefaultValue()).findFirst().orElse(null)));
        });
        this.addWidget((GuiEventListener)this.resetButton);
        this.resetButton.setTooltip(Tooltip.create((Component)ConfigScreenUtils.createTooltipText(this.config)));
        super.init();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.doneButton.render(graphics, mouseX, mouseY, partialTicks);
        this.cancelButton.render(graphics, mouseX, mouseY, partialTicks);
        this.resetButton.render(graphics, mouseX, mouseY, partialTicks);
        this.resetButton.active = !this.value.equals(this.config.getDefaultValue());
        graphics.drawCenteredString(this.font, this.subtitle, this.width / 2, 20, -1);
    }

    public class EnumList
    extends ModObjectSelectionList<com.craftjakob.configapi.client.screen.EnumConfigScreen$EnumList.Entry> {
        public EnumList(int buttonSpacing) {
            super(EnumConfigScreen.this.minecraft, EnumConfigScreen.this.width, EnumConfigScreen.this.height - 64, 32, buttonSpacing);
            Stream.of(EnumConfigScreen.this.values).map(x$0 -> new Entry((Enum<?>)x$0)).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        public int getRowWidth() {
            return this.width;
        }

        public class Entry
        extends ModObjectSelectionList.Entry<com.craftjakob.configapi.client.screen.EnumConfigScreen$EnumList.Entry> {
            protected final Enum<?> value;
            private final Component name;

            public Entry(Enum<?> value) {
                this.value = value;
                this.name = Component.literal((String)value.name());
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                graphics.drawCenteredString(EnumConfigScreen.this.font, this.name, entryLeft + entryRight / 2, entryTop + 6, -1);
            }

            @NotNull
            public Component getNarration() {
                return this.name;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                EnumConfigScreen.this.list.setSelected((AbstractSelectionList.Entry)this);
                EnumConfigScreen.this.value = this.value;
                return true;
            }
        }
    }
}

