/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.list;

import com.craftjakob.configapi.client.ConfigScreenUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.NotNull;

public class ValueList<E extends Entry<E>>
extends ContainerObjectSelectionList<E> {
    public ValueList(Minecraft minecraft, int width, int height, int listHeight, int buttonSpacing) {
        super(minecraft, width, height, listHeight, buttonSpacing);
    }

    public void refreshEntries() {
        this.children().forEach(Entry::refreshEntry);
    }

    public static abstract class Entry<E extends Entry<E>>
    extends ContainerObjectSelectionList.Entry<E> {
        protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        private final String entryName;

        public Entry(String entryName) {
            this.entryName = entryName;
        }

        public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ConfigScreenUtils.highlightEntry(graphics, entryLeft, entryRight, entryTop, entryHeight, hovered);
        }

        public abstract void refreshEntry();

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public String getEntryName() {
            return this.entryName;
        }
    }
}

