/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ImageTextButton
extends Button {
    private final Component buttonText;
    private final ResourceLocation image;
    private final int imageWidth;
    private final int imageHeight;

    public ImageTextButton(int x, int y, int width, int height, Component buttonText, ResourceLocation image, int imageWidth, int imageHeight, Button.OnPress onPress) {
        super(x, y, width, height, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
        this.buttonText = buttonText;
        this.image = image;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        int textWidth = Minecraft.getInstance().font.width((FormattedText)this.buttonText);
        int totalWidth = this.imageWidth + 2 + textWidth;
        int imageX = this.getX() + (this.width - totalWidth) / 2 - 1;
        int textX = imageX + this.imageWidth + 2;
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.image, imageX, this.getY(), 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        graphics.drawString(Minecraft.getInstance().font, this.buttonText, textX, this.getY() + this.height / 2 / 2 + 1, -1);
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }
}

