/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.config;

import com.craftjakob.configapi.ConfigAPI;
import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.config.IConfigurator;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;

public final class ConfigRegister {
    private static final EnumMap<Config.ConfigType, Set<Config>> CONFIGS_SETS = new EnumMap(Config.ConfigType.class);

    private ConfigRegister() {
    }

    public static void registerConfig(String modId, Config.ConfigType type, Supplier<? extends IConfigurator> configuratorSupplier, boolean isTracked, String filePath) {
        String formattedPath = Config.configPath(modId, type, filePath);
        if (CONFIGS_SETS.values().stream().anyMatch(configs -> configs.stream().anyMatch(config -> config.getFilePath().equals(formattedPath)))) {
            throw new RuntimeException("Already registered config name: " + formattedPath);
        }
        CONFIGS_SETS.get((Object)type).add(new Config(modId, type, configuratorSupplier.get(), isTracked, formattedPath));
        ConfigAPI.LOGGER.info("Registered config for: {} as {}", (Object)modId, (Object)formattedPath);
    }

    public static void registerConfig(String modId, Config.ConfigType type, Supplier<? extends IConfigurator> configuratorSupplier, String filePath) {
        ConfigRegister.registerConfig(modId, type, configuratorSupplier, true, filePath);
    }

    public static void registerConfig(String modId, Config.ConfigType type, Supplier<? extends IConfigurator> configuratorSupplier, boolean isTracked) {
        ConfigRegister.registerConfig(modId, type, configuratorSupplier, isTracked, Config.configName(modId, type));
    }

    public static void registerConfig(String modId, Config.ConfigType type, Supplier<? extends IConfigurator> configuratorSupplier) {
        ConfigRegister.registerConfig(modId, type, configuratorSupplier, true);
    }

    public static EnumMap<Config.ConfigType, Set<Config>> getConfigSets() {
        return CONFIGS_SETS;
    }

    static {
        CONFIGS_SETS.put(Config.ConfigType.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        CONFIGS_SETS.put(Config.ConfigType.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        CONFIGS_SETS.put(Config.ConfigType.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }
}

