/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.example;

import com.craftjakob.configapi.config.ConfigBuilder;
import com.craftjakob.configapi.config.ConfigValueTypes;
import com.craftjakob.configapi.config.IConfigurator;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;

public class ExampleConfig
implements IConfigurator {
    public static ConfigValueTypes.ConfigValue<Boolean> AConfigWithoutAComment;
    public static ConfigValueTypes.ConfigValue<Boolean> WithoutCategoryConfig;
    public static ConfigValueTypes.ConfigValue<Boolean> ConfigValueOfBoolean;
    public static ConfigValueTypes.ConfigValue<Character> ConfigValueOfCharacter;
    public static ConfigValueTypes.ConfigValue<String> ConfigValueOfString;
    public static ConfigValueTypes.ConfigValue<Enum<ChatFormatting>> ConfigValueOfEnum;
    public static ConfigValueTypes.ConfigValue<List<Boolean>> ConfigValueListOfBoolean;
    public static ConfigValueTypes.ConfigValue<? extends List<Double>> ConfigValueListOfDouble;
    public static ConfigValueTypes.ConfigValue<Integer> ConfigValueOfIntegerWithoutRange;
    public static ConfigValueTypes.ConfigValue<Integer> ConfigValueOfIntegerWithRange;
    public static ConfigValueTypes.NumberValue<Byte> NumberValueOfByte;
    public static ConfigValueTypes.NumberValue<Short> NumberValueOfShort;
    public static ConfigValueTypes.NumberValue<Integer> NumberValueOfInteger;
    public static ConfigValueTypes.NumberValue<Long> NumberValueOfLong;
    public static ConfigValueTypes.NumberValue<Float> NumberValueOfFloat;
    public static ConfigValueTypes.NumberValue<Double> NumberValueOfDouble;
    public static ConfigValueTypes.BooleanValue BooleanValue;
    public static ConfigValueTypes.CharacterValue CharacterValue;
    public static ConfigValueTypes.StringValue StringValue;
    public static ConfigValueTypes.EnumValue<ChatFormatting> EnumValue;
    public static ConfigValueTypes.ListValue<Boolean> ListValueOfBoolean;
    public static ConfigValueTypes.ListValue<Integer> ListValueOfInteger;
    public static ConfigValueTypes.ByteValue ByteValue;
    public static ConfigValueTypes.ShortValue ShortValue;
    public static ConfigValueTypes.IntegerValue IntegerValue;
    public static ConfigValueTypes.LongValue LongValue;
    public static ConfigValueTypes.FloatValue FloatValue;
    public static ConfigValueTypes.DoubleValue DoubleValue;

    @Override
    public void configure(ConfigBuilder builder) {
        AConfigWithoutAComment = builder.define("AConfigWithoutAComment", true);
        WithoutCategoryConfig = builder.comment("This is a Config without a category!").defineValue("WithoutCategoryConfig", true);
        builder.comment("A Comment for the Category ConfigValuesOf").translation("test.configapi.translation").push("ConfigValuesOf");
        ConfigValueOfBoolean = builder.onlyForModLoader("Forge", "NeoForge").comment("A Config Value of Boolean").defineValue("ConfigValueOfBoolean", true);
        ConfigValueOfCharacter = builder.onlyForModLoader(new String[0]).comment("A Config Value of Character").defineValue("ConfigValueOfCharacter", 'A');
        ConfigValueOfString = builder.comment("A Config Value of String").defineValue("ConfigValueOfString", "DefaultValue");
        ConfigValueOfEnum = builder.comment("A Config Value of Enum", "Second Comment", "Third Comment").defineEnumValue("ConfigValueOfEnum", ChatFormatting.AQUA);
        ConfigValueListOfBoolean = builder.comment("A Config Value List of Boolean").defineListValue("ConfigValueListOfBoolean", List.of(Boolean.valueOf(true), Boolean.valueOf(false)), Boolean::parseBoolean);
        ConfigValueListOfDouble = builder.comment("A Config Value List of Double").defineListValue("ConfigValueListOfDouble", Arrays.asList(0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0), Double::parseDouble);
        ConfigValueOfIntegerWithoutRange = builder.comment("A Config Value of Integer without a Range").defineValue("ConfigValueOfIntegerWithoutRange", 10, Integer::parseInt);
        ConfigValueOfIntegerWithRange = builder.comment("A Config Value of Integer with a Range").defineInRange("ConfigValueOfIntegerWithRange", 10, 0, 20);
        builder.comment("A Comment for the Category NumberValuesOf").push("NumberValuesOf");
        NumberValueOfByte = builder.comment("A Number Value of Byte").defineInRange("NumberValueOfByte", (byte)3, (byte)-128, (byte)127);
        NumberValueOfShort = builder.comment("A Number Value of Short").defineInRange("NumberValueOfShort", (short)10, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        NumberValueOfInteger = builder.comment("A Number Value of Integer").defineInRange("NumberValueOfInteger", 10, Integer.MIN_VALUE, Integer.MAX_VALUE);
        NumberValueOfLong = builder.comment("A Number Value of Long").defineInRange("NumberValueOfLong", 10L, Long.MIN_VALUE, Long.MAX_VALUE);
        NumberValueOfFloat = builder.comment("A Number Value of Float").defineInRange("NumberValueOfFloat", 10.0f, Float.MIN_VALUE, Float.MAX_VALUE);
        NumberValueOfDouble = builder.comment("A Number Value of Double").defineInRange("NumberValueOfDouble", 10.0, Double.MIN_VALUE, Double.MAX_VALUE);
        builder.pop();
        builder.comment("A Comment for the Category Direct Config").push("Direct Config");
        BooleanValue = builder.requiresClientRestart().define("BooleanValue", true);
        CharacterValue = builder.requiresClientRestart().define("CharacterValue", 'A');
        StringValue = builder.requiresClientRestart().define("StringValue", "DefaultValueForStringValue");
        EnumValue = builder.requiresClientRestart().defineEnum("EnumValue", ChatFormatting.GOLD);
        ListValueOfBoolean = builder.requiresClientRestart().defineList("ListValueOfBoolean", List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), Boolean::parseBoolean);
        ListValueOfInteger = builder.requiresClientRestart().defineList("ListValueOfInteger", List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10), Integer::parseInt);
        builder.push("NumberValues");
        ByteValue = builder.requiresWorldRestart().defineInRange("ByteValue", (byte)1, (byte)0, (byte)10);
        ShortValue = builder.requiresWorldRestart().defineInRange("ShortValue", (short)5, (short)2, (short)12);
        IntegerValue = builder.requiresWorldRestart().defineInRange("IntegerValue", 10, -20, 100);
        LongValue = builder.requiresWorldRestart().defineInRange("LongValue", 100L, -1000L, 1000L);
        FloatValue = builder.requiresWorldRestart().defineInRange("FloatValue", 22.2f, 0.0f, 100.0f);
        DoubleValue = builder.requiresWorldRestart().defineInRange("DoubleValue", 25.0, 0.0, 100.0);
        builder.pop();
        builder.pop();
        builder.pop();
    }
}

