/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event;

import com.craftjakob.event.events.client.ClientCommandEvent;
import com.craftjakob.event.events.client.ClientLifecycleEvent;
import com.craftjakob.event.events.client.ClientPlayerEvent;
import com.craftjakob.event.events.client.ClientTickEvent;
import com.craftjakob.event.events.common.InteractionEvent;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public final class EventHandlerImplClient {
    private EventHandlerImplClient() {
    }

    @SubscribeEvent(priority=80)
    public static void event(RegisterClientCommandsEvent event) {
        ClientCommandEvent.REGISTRATION.invoker().registration((CommandDispatcher<ClientCommandEvent.ClientCommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent(priority=80)
    public static void event(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientPlayerEvent.CLIENT_JOIN.invoker().join(event.getPlayer(), event.getPlayer().connection);
    }

    @SubscribeEvent(priority=80)
    public static void event(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() != null) {
            ClientPlayerEvent.CLIENT_QUIT.invoker().quit(event.getPlayer(), event.getPlayer().connection, Minecraft.getInstance());
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(ClientPlayerNetworkEvent.Clone event) {
        ClientPlayerEvent.CLIENT_RESPAWN.invoker().respawn(event.getOldPlayer(), event.getNewPlayer());
    }

    @SubscribeEvent(priority=80)
    public static void event(final ComputeFovModifierEvent event) {
        ClientPlayerEvent.FOV_MODIFIER.invoker().modifyFov((LocalPlayer)event.getPlayer(), event.getScale(), new ClientPlayerEvent.FovModifier.Context(){

            @Override
            public float getOriginalFovModifier() {
                return event.getFovModifier();
            }

            @Override
            public float getNewFovModifier() {
                return event.getNewFovModifier();
            }

            @Override
            public void setNewFovModifier(float newFovModifier) {
                event.setNewFovModifier(newFovModifier);
            }
        });
    }

    @SubscribeEvent(priority=80)
    public static void event(TickEvent.ClientTickEvent.Pre event) {
        ClientTickEvent.CLIENT_PRE.invoker().tick(Minecraft.getInstance());
    }

    @SubscribeEvent(priority=80)
    public static void event(TickEvent.ClientTickEvent.Post event) {
        ClientTickEvent.CLIENT_POST.invoker().tick(Minecraft.getInstance());
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerInteractEvent.LeftClickEmpty event) {
        InteractionEvent.CLIENT_LEFT_CLICK_AIR.invoker().click(event.getEntity(), event.getHand());
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerInteractEvent.RightClickEmpty event) {
        InteractionEvent.CLIENT_RIGHT_CLICK_AIR.invoker().click(event.getEntity(), event.getHand());
    }

    @SubscribeEvent(priority=80)
    public static void event(FMLClientSetupEvent event) {
        ClientLifecycleEvent.CLIENT_SETUP.invoker().stateChanged(Minecraft.getInstance());
    }
}

