/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event;

import com.craftjakob.event.EventResult;
import com.craftjakob.event.events.common.BlockEvent;
import com.craftjakob.event.events.common.BrewingRecipesEvent;
import com.craftjakob.event.events.common.ChunkEvent;
import com.craftjakob.event.events.common.CommandEvent;
import com.craftjakob.event.events.common.EntityEvent;
import com.craftjakob.event.events.common.ExplosionEvent;
import com.craftjakob.event.events.common.InteractionEvent;
import com.craftjakob.event.events.common.LifecycleEvent;
import com.craftjakob.event.events.common.PlayerEvent;
import com.craftjakob.event.events.common.TickEvent;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.BrewingRecipeRegisterEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public final class EventHandlerImplCommon {
    private EventHandlerImplCommon() {
    }

    @SubscribeEvent(priority=80)
    public static void event(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getLevel();
            if (player instanceof Level) {
                Level level = (Level)player;
                if (BlockEvent.BREAK.invoker().breakBlock(level, event.getPos(), event.getState(), serverPlayer).isFalse()) {
                    event.setResult(Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent(priority=80)
    public static boolean event(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            return BlockEvent.PLACE.invoker().placeBlock(level, event.getPos(), event.getState(), event.getEntity()).isFalse();
        }
        return false;
    }

    @SubscribeEvent(priority=80)
    public static void event(BrewingRecipeRegisterEvent event) {
        BrewingRecipesEvent.BUILD.invoker().onBuild(event.getBuilder());
    }

    @SubscribeEvent(priority=80)
    public static void chunkDataLoadEvent(ChunkDataEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkEvent.LOAD_DATA.invoker().loadData(serverLevel, event.getChunk(), event.getStatus(), event.getData());
        }
    }

    @SubscribeEvent(priority=80)
    public static void chunkDataSaveEvent(ChunkDataEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkEvent.SAVE_DATA.invoker().saveData(serverLevel, event.getChunk(), event.getData());
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(RegisterCommandsEvent event) {
        CommandEvent.REGISTRATION.invoker().registration((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent(priority=80)
    public static boolean event(EntityJoinLevelEvent event) {
        return EntityEvent.ADD.invoker().add(event.getEntity(), event.getLevel()).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static void event(EntityLeaveLevelEvent event) {
        EntityEvent.REMOVE.invoker().remove(event.getEntity(), event.getLevel());
    }

    @SubscribeEvent(priority=80)
    public static boolean event(EntityMountEvent event) {
        return EntityEvent.MOUNT.invoker().mount(event.getLevel(), event.getEntityMounting(), event.getEntityBeingMounted(), event.isMounting()).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static boolean event(AnimalTameEvent event) {
        return EntityEvent.ANIMAL_TAME.invoker().tame(event.getAnimal(), event.getTamer()).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static boolean event(final LivingHealEvent event) {
        EntityEvent.LivingHeal.Context context = new EntityEvent.LivingHeal.Context(){

            @Override
            public float getAmount() {
                return event.getAmount();
            }

            @Override
            public void setAmount(float amount) {
                event.setAmount(amount);
            }
        };
        return EntityEvent.LIVING_HEAL.invoker().heal(event.getEntity(), context).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static boolean event(LivingHurtEvent event) {
        return EntityEvent.LIVING_HURT.invoker().hurt(event.getEntity(), event.getSource(), event.getAmount()).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static boolean event(LivingDeathEvent event) {
        return EntityEvent.LIVING_DEATH.invoker().death(event.getEntity(), event.getSource()).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static void event(EntityEvent.EnteringSection event) {
        EntityEvent.ENTER_SECTION.invoker().enterSection(event.getEntity(), event.getNewPos().getX(), event.getNewPos().getY(), event.getNewPos().getZ(), event.getNewPos().getX(), event.getNewPos().getY(), event.getNewPos().getZ());
    }

    @SubscribeEvent(priority=80)
    public static boolean event(ExplosionEvent.Start event) {
        return ExplosionEvent.PRE.invoker().explode(event.getLevel(), event.getExplosion()).isFalse();
    }

    @SubscribeEvent(priority=80)
    public static void event(ExplosionEvent.Detonate event) {
        ExplosionEvent.DETONATE.invoker().explode(event.getLevel(), event.getExplosion(), event.getAffectedEntities());
    }

    @SubscribeEvent(priority=80)
    public static boolean event(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return false;
        }
        InteractionResult result = InteractionEvent.LEFT_CLICK_BLOCK.invoker().click(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace());
        if (result != InteractionResult.PASS) {
            event.setUseBlock(result.consumesAction() ? Result.ALLOW : Result.DENY);
            event.setUseItem(result.consumesAction() ? Result.ALLOW : Result.DENY);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = InteractionEvent.RIGHT_CLICK_BLOCK.invoker().click(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCancellationResult(result);
            event.setUseBlock(Result.ALLOW);
            event.setUseItem(Result.DENY);
        }
    }

    @SubscribeEvent(priority=80)
    public static boolean event(PlayerInteractEvent.RightClickItem event) {
        InteractionResult result = InteractionEvent.RIGHT_CLICK_ITEM.invoker().click(event.getEntity(), event.getLevel(), event.getHand());
        if (result != InteractionResult.PASS) {
            event.setCancellationResult(result);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=80)
    public static boolean event(PlayerInteractEvent.EntityInteract event) {
        EventResult result = InteractionEvent.INTERACT_ENTITY.invoker().interact(event.getEntity(), event.getTarget(), event.getHand());
        if (result.isPresent()) {
            event.setCancellationResult(result.asMinecraft());
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent(priority=80)
    public static boolean event(BlockEvent.FarmlandTrampleEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) return false;
        Level level = (Level)levelAccessor;
        if (InteractionEvent.FARMLAND_TRAMPLE.invoker().trample(level, event.getPos(), event.getState(), event.getFallDistance(), event.getEntity()) != InteractionResult.PASS) return false;
        return true;
    }

    @SubscribeEvent(priority=80)
    public static void event(ServerAboutToStartEvent event) {
        LifecycleEvent.SERVER_BEFORE_START.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void event(ServerStartingEvent event) {
        LifecycleEvent.SERVER_STARTING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void event(ServerStartedEvent event) {
        LifecycleEvent.SERVER_STARTED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void event(ServerStoppingEvent event) {
        LifecycleEvent.SERVER_STOPPING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void event(ServerStoppedEvent event) {
        LifecycleEvent.SERVER_STOPPED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void eventWorldEvent(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LifecycleEvent.SERVER_LEVEL_LOAD.invoker().stateChanged(event.getLevel().getServer(), serverLevel);
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LifecycleEvent.SERVER_LEVEL_UNLOAD.invoker().stateChanged(event.getLevel().getServer(), serverLevel);
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(LevelEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            LifecycleEvent.SERVER_LEVEL_SAVE.invoker().stateChanged(event.getLevel().getServer(), serverLevel);
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEvent.JOIN.invoker().join(event.getEntity());
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEvent.QUIT.invoker().quit(event.getEntity());
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer oldPlayer = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                PlayerEvent.CLONE.invoker().clone(oldPlayer, newPlayer, !event.isWasDeath());
            }
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvent.RESPAWN.invoker().respawn(serverPlayer, event.isEndConquered(), event.getEntity().getRemovalReason());
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvent.ADVANCEMENT.invoker().award(serverPlayer, event.getAdvancement());
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(ItemTossEvent event) {
        PlayerEvent.DROP_ITEM.invoker().drop(event.getPlayer(), event.getEntity());
    }

    @SubscribeEvent(priority=80)
    public static boolean event(AttackEntityEvent event) {
        EventResult result = PlayerEvent.ATTACK_ENTITY.invoker().attack(event.getEntity(), event.getEntity().level(), event.getTarget(), event.getEntity().getUsedItemHand(), null);
        return result.isFalse();
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvent.CHANGE_DIMENSION.invoker().change(serverPlayer, (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
        }
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerContainerEvent.Open event) {
        PlayerEvent.OPEN_MENU.invoker().open(event.getEntity(), event.getContainer());
    }

    @SubscribeEvent(priority=80)
    public static void event(PlayerContainerEvent.Close event) {
        PlayerEvent.CLOSE_MENU.invoker().close(event.getEntity(), event.getContainer());
    }

    @SubscribeEvent(priority=80)
    public static void serverTickPoreEvent(TickEvent.ServerTickEvent.Pre event) {
        TickEvent.SERVER_PRE.invoker().tick(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void serverTickPostEvent(TickEvent.ServerTickEvent.Post event) {
        TickEvent.SERVER_POST.invoker().tick(event.getServer());
    }

    @SubscribeEvent(priority=80)
    public static void levelTickPreEvent(TickEvent.LevelTickEvent.Pre event) {
        Level level;
        if (!event.level.isClientSide() && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TickEvent.SERVER_LEVEL_PRE.invoker().tick(serverLevel);
        }
    }

    @SubscribeEvent(priority=80)
    public static void levelTickPostEvent(TickEvent.LevelTickEvent.Post event) {
        Level level;
        if (!event.level.isClientSide() && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TickEvent.SERVER_LEVEL_POST.invoker().tick(serverLevel);
        }
    }

    @SubscribeEvent(priority=80)
    public static void playerTickPreEvent(TickEvent.PlayerTickEvent.Pre event) {
        TickEvent.PLAYER_PRE.invoker().tick(event.player);
    }

    @SubscribeEvent(priority=80)
    public static void playerTickPostevent(TickEvent.PlayerTickEvent.Post event) {
        TickEvent.PLAYER_POST.invoker().tick(event.player);
    }

    @SubscribeEvent(priority=80)
    public static void event(FMLCommonSetupEvent event) {
        LifecycleEvent.SETUP.invoker().run();
    }
}

