/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event;

import net.minecraft.world.InteractionResult;

public enum EventResult {
    TRUE(true, true),
    FALSE(true, false),
    STOP(true, null),
    PASS(false, null);

    private final boolean interrupts;
    private final Boolean value;

    private EventResult(boolean interrupts, Boolean value) {
        this.interrupts = interrupts;
        this.value = value;
    }

    public boolean interrupts() {
        return this.interrupts;
    }

    public Boolean value() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isTrue() {
        return Boolean.TRUE.equals(this.value);
    }

    public boolean isFalse() {
        return Boolean.FALSE.equals(this.value);
    }

    public InteractionResult asMinecraft() {
        if (this.isPresent()) {
            return this.value != false ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public <T> Value<T> with(T returnedValue) {
        return new Value<T>(this, returnedValue);
    }

    public static class Value<T> {
        private final EventResult result;
        private final T returnedValue;

        private Value(EventResult result, T returnedValue) {
            this.result = result;
            this.returnedValue = returnedValue;
        }

        public EventResult result() {
            return this.result;
        }

        public T get() {
            return this.returnedValue;
        }
    }
}

