/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event.events.common;

import com.craftjakob.event.Event;
import com.craftjakob.event.EventFactory;
import com.craftjakob.event.EventResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface EntityEvent {
    public static final Event<Add> ADD = EventFactory.createEventResult(new Add[0]);
    public static final Event<Remove> REMOVE = EventFactory.createLoop(new Remove[0]);
    public static final Event<Mount> MOUNT = EventFactory.createEventResult(new Mount[0]);
    public static final Event<AnimalTame> ANIMAL_TAME = EventFactory.createEventResult(new AnimalTame[0]);
    public static final Event<OnBlock> ON_BLOCK = EventFactory.createLoop(new OnBlock[0]);
    public static final Event<OnDisable> ON_BLOCK_DISABLE = EventFactory.createLoop(new OnDisable[0]);
    public static final Event<LivingHeal> LIVING_HEAL = EventFactory.createEventResult(new LivingHeal[0]);
    public static final Event<LivingHurt> LIVING_HURT = EventFactory.createEventResult(new LivingHurt[0]);
    public static final Event<LivingDeath> LIVING_DEATH = EventFactory.createEventResult(new LivingDeath[0]);
    public static final Event<EnterSection> ENTER_SECTION = EventFactory.createLoop(new EnterSection[0]);

    @FunctionalInterface
    public static interface Add {
        public EventResult add(Entity var1, Level var2);
    }

    @FunctionalInterface
    public static interface Remove {
        public void remove(Entity var1, Level var2);
    }

    @FunctionalInterface
    public static interface Mount {
        public EventResult mount(Level var1, Entity var2, Entity var3, boolean var4);
    }

    @FunctionalInterface
    public static interface AnimalTame {
        public EventResult tame(Animal var1, Player var2);
    }

    @FunctionalInterface
    public static interface OnBlock {
        public void onBlock(LivingEntity var1, DamageSource var2, ItemStack var3, Context var4);

        public static interface Context {
            public float getOriginalDamageAmount();

            public float getBlockedDamage();

            public void setBlockedDamage(float var1);

            public boolean isShieldTakingDamage();
        }
    }

    @FunctionalInterface
    public static interface OnDisable {
        public void onDisable(LivingEntity var1, ItemStack var2, Context var3);

        public static interface Context {
            public int getDefaultCooldownTicks();

            public int getCooldownTicks();

            public void setCooldownTicks(int var1);
        }
    }

    @FunctionalInterface
    public static interface LivingHeal {
        public EventResult heal(LivingEntity var1, Context var2);

        public static interface Context {
            public float getAmount();

            public void setAmount(float var1);
        }
    }

    @FunctionalInterface
    public static interface LivingHurt {
        public EventResult hurt(LivingEntity var1, DamageSource var2, float var3);
    }

    @FunctionalInterface
    public static interface LivingDeath {
        public EventResult death(LivingEntity var1, DamageSource var2);
    }

    @FunctionalInterface
    public static interface EnterSection {
        public void enterSection(Entity var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

