/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.event.events.common;

import com.craftjakob.event.Event;
import com.craftjakob.event.EventFactory;
import com.craftjakob.event.EventResult;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public interface PlayerEvent {
    public static final Event<Join> JOIN = EventFactory.createLoop(new Join[0]);
    public static final Event<Quit> QUIT = EventFactory.createLoop(new Quit[0]);
    public static final Event<Clone> CLONE = EventFactory.createLoop(new Clone[0]);
    public static final Event<Respawn> RESPAWN = EventFactory.createLoop(new Respawn[0]);
    public static final Event<Advancement> ADVANCEMENT = EventFactory.createLoop(new Advancement[0]);
    public static final Event<DropItem> DROP_ITEM = EventFactory.createEventResult(new DropItem[0]);
    public static final Event<PickupItemPredicate> PICKUP_ITEM_PRE = EventFactory.createEventResult(new PickupItemPredicate[0]);
    public static final Event<PickupItem> PICKUP_ITEM_POST = EventFactory.createLoop(new PickupItem[0]);
    public static final Event<AttackEntity> ATTACK_ENTITY = EventFactory.createEventResult(new AttackEntity[0]);
    public static final Event<ChangeDimension> CHANGE_DIMENSION = EventFactory.createLoop(new ChangeDimension[0]);
    public static final Event<OpenMenu> OPEN_MENU = EventFactory.createLoop(new OpenMenu[0]);
    public static final Event<CloseMenu> CLOSE_MENU = EventFactory.createLoop(new CloseMenu[0]);

    @FunctionalInterface
    public static interface Join {
        public void join(Player var1);
    }

    @FunctionalInterface
    public static interface Quit {
        public void quit(Player var1);
    }

    @FunctionalInterface
    public static interface Clone {
        public void clone(ServerPlayer var1, ServerPlayer var2, boolean var3);
    }

    @FunctionalInterface
    public static interface Respawn {
        public void respawn(ServerPlayer var1, boolean var2, Entity.RemovalReason var3);
    }

    @FunctionalInterface
    public static interface Advancement {
        public void award(ServerPlayer var1, AdvancementHolder var2);
    }

    @FunctionalInterface
    public static interface DropItem {
        public EventResult drop(Player var1, ItemEntity var2);
    }

    @FunctionalInterface
    public static interface PickupItemPredicate {
        public EventResult canPickup(Player var1, ItemEntity var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface PickupItem {
        public void pickup(Player var1, ItemEntity var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface AttackEntity {
        public EventResult attack(Player var1, Level var2, Entity var3, InteractionHand var4, @Nullable EntityHitResult var5);
    }

    @FunctionalInterface
    public static interface ChangeDimension {
        public void change(ServerPlayer var1, ResourceKey<Level> var2, ResourceKey<Level> var3);
    }

    @FunctionalInterface
    public static interface OpenMenu {
        public void open(Player var1, AbstractContainerMenu var2);
    }

    @FunctionalInterface
    public static interface CloseMenu {
        public void close(Player var1, AbstractContainerMenu var2);
    }
}

