/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.hooks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.internal.Event;

public final class EventBusGroupHooks {
    private static final Map<String, BusGroup> EVENT_BUS_GROUPS_BY_MOD_ID = Collections.synchronizedMap(new HashMap());

    private EventBusGroupHooks() {
    }

    public static BusGroup putModEventBus(String modId, BusGroup bus) {
        if (EVENT_BUS_GROUPS_BY_MOD_ID.putIfAbsent(modId, bus) != null) {
            throw new IllegalArgumentException("IEventBus with the modId: '" + modId + "' is already registered!");
        }
        return bus;
    }

    public static <E extends Event, B extends EventBus<E>> void ifAvailable(String modId, Function<BusGroup, B> function, Consumer<B> bus) {
        EventBusGroupHooks.ifAvailable(modId, busGroup -> bus.accept((EventBus)function.apply((BusGroup)busGroup)));
    }

    public static <E extends Event, B extends EventBus<E>> void ifAvailable(String modId, Function<BusGroup, B> function, Consumer<B> bus, Runnable fallback) {
        EventBusGroupHooks.ifAvailable(modId, (BusGroup busGroup) -> bus.accept((EventBus)function.apply((BusGroup)busGroup)), fallback);
    }

    public static void ifAvailable(String modId, Consumer<BusGroup> busConsumer) {
        EventBusGroupHooks.ifAvailable(modId, busConsumer, () -> {
            throw new IllegalArgumentException("Mod with the modId: '" + modId + "' is not available!");
        });
    }

    public static void ifAvailable(String modId, Consumer<BusGroup> busConsumer, Runnable fallback) {
        Optional<BusGroup> optionalEventBus = EventBusGroupHooks.getModEventBus(modId);
        if (optionalEventBus.isPresent()) {
            busConsumer.accept(optionalEventBus.get());
        } else {
            fallback.run();
        }
    }

    public static Optional<BusGroup> getModEventBus(String modId) {
        return Optional.ofNullable(EVENT_BUS_GROUPS_BY_MOD_ID.get(modId));
    }
}

