/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.hooks.level.biome;

import com.craftjakob.hooks.level.biome.BiomeSettings;
import com.craftjakob.hooks.level.biome.ClimateSettings;
import com.craftjakob.hooks.level.biome.EffectsSettings;
import com.craftjakob.hooks.level.biome.GenerationSettings;
import com.craftjakob.hooks.level.biome.SpawnSettings;
import com.craftjakob.mixin.accessor.BiomeAccessor;
import com.craftjakob.mixin.accessor.MobSpawnSettingsAccessor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public final class BiomeHooks {
    private BiomeHooks() {
    }

    public static BiomeSettings getBiomeSettings(Biome biome) {
        return new BiomeSettingsWrapped(biome);
    }

    public static class BiomeSettingsWrapped
    implements BiomeSettings {
        private final ClimateSettings climateSettings;
        private final EffectsSettings effectsSettings;
        private final GenerationSettings generationSettings;
        private final SpawnSettings spawnSettings;

        public BiomeSettingsWrapped(Biome biome) {
            this(new ClimateSettingsWrapped(biome), new EffectsSettingsWrapped(biome), new GenerationSettingsWrapped(biome), new SpawnSettingsWrapped(biome));
        }

        public BiomeSettingsWrapped(ClimateSettings climateSettings, EffectsSettings effectsSettings, GenerationSettings generationSettings, SpawnSettings spawnSettings) {
            this.climateSettings = climateSettings;
            this.effectsSettings = effectsSettings;
            this.generationSettings = generationSettings;
            this.spawnSettings = spawnSettings;
        }

        @Override
        public ClimateSettings getClimateProperties() {
            return this.climateSettings;
        }

        @Override
        public EffectsSettings getEffectsProperties() {
            return this.effectsSettings;
        }

        @Override
        public GenerationSettings getGenerationProperties() {
            return this.generationSettings;
        }

        @Override
        public SpawnSettings getSpawnProperties() {
            return this.spawnSettings;
        }
    }

    public static abstract class MutableSpawnSettingsWrapped
    extends SpawnSettingsWrapped
    implements SpawnSettings.Mutable {
        public MutableSpawnSettingsWrapped(Biome biome) {
            super(biome);
        }
    }

    public static class SpawnSettingsWrapped
    implements SpawnSettings {
        private final MobSpawnSettings mobSpawnSettings;

        public SpawnSettingsWrapped(Biome biome) {
            this(biome.getMobSettings());
        }

        public SpawnSettingsWrapped(MobSpawnSettings mobSpawnSettings) {
            this.mobSpawnSettings = mobSpawnSettings;
        }

        @Override
        public float getCreatureProbability() {
            return this.mobSpawnSettings.getCreatureProbability();
        }

        @Override
        public Map<MobCategory, WeightedList<MobSpawnSettings.SpawnerData>> getSpawners() {
            return ((MobSpawnSettingsAccessor)this.mobSpawnSettings).getSpawners();
        }

        @Override
        public Map<EntityType<?>, MobSpawnSettings.MobSpawnCost> getMobSpawnCosts() {
            return ((MobSpawnSettingsAccessor)this.mobSpawnSettings).getMobSpawnCosts();
        }

        @Override
        public WeightedList<MobSpawnSettings.SpawnerData> getMobs(MobCategory mobCategory) {
            return this.mobSpawnSettings.getMobs(mobCategory);
        }

        @Override
        public MobSpawnSettings.MobSpawnCost getMobSpawnCost(EntityType<?> entityType) {
            return this.mobSpawnSettings.getMobSpawnCost(entityType);
        }
    }

    public static abstract class MutableGenerationSettingsWrapped
    extends GenerationSettingsWrapped
    implements GenerationSettings.Mutable {
        public MutableGenerationSettingsWrapped(Biome biome) {
            super(biome);
        }
    }

    public static class GenerationSettingsWrapped
    implements GenerationSettings {
        private final BiomeGenerationSettings generationSettings;

        public GenerationSettingsWrapped(Biome biome) {
            this(biome.getGenerationSettings());
        }

        public GenerationSettingsWrapped(BiomeGenerationSettings generationSettings) {
            this.generationSettings = generationSettings;
        }

        @Override
        public boolean hasFeature(PlacedFeature placedFeature) {
            return this.generationSettings.hasFeature(placedFeature);
        }

        @Override
        public Iterable<Holder<ConfiguredWorldCarver<?>>> getCarvers() {
            return this.generationSettings.getCarvers();
        }

        @Override
        public List<HolderSet<PlacedFeature>> getFeatures() {
            return this.generationSettings.features();
        }

        @Override
        public HolderSet<PlacedFeature> getFeatures(GenerationStep.Decoration decoration) {
            if (decoration.ordinal() >= this.generationSettings.features().size()) {
                return HolderSet.empty();
            }
            return (HolderSet)this.generationSettings.features().get(decoration.ordinal());
        }

        @Override
        public List<ConfiguredFeature<?, ?>> getFlowerFeatures() {
            return this.generationSettings.getFlowerFeatures();
        }
    }

    public static abstract class MutableEffectsSettingsWrapped
    extends EffectsSettingsWrapped
    implements EffectsSettings.Mutable {
        public MutableEffectsSettingsWrapped(Biome biome) {
            super(biome);
        }
    }

    public static class EffectsSettingsWrapped
    implements EffectsSettings {
        private final BiomeSpecialEffects effects;

        public EffectsSettingsWrapped(Biome biome) {
            this(biome.getSpecialEffects());
        }

        public EffectsSettingsWrapped(BiomeSpecialEffects effects) {
            this.effects = effects;
        }

        @Override
        public int getFogColor() {
            return this.effects.getFogColor();
        }

        @Override
        public int getWaterColor() {
            return this.effects.getWaterColor();
        }

        @Override
        public int getWaterFogColor() {
            return this.effects.getWaterFogColor();
        }

        @Override
        public int getSkyColor() {
            return this.effects.getSkyColor();
        }

        @Override
        public Optional<Integer> getFoliageColorOverride() {
            return this.effects.getFoliageColorOverride();
        }

        @Override
        public Optional<Integer> getDryFoliageColorOverride() {
            return this.effects.getDryFoliageColorOverride();
        }

        @Override
        public Optional<Integer> getGrassColorOverride() {
            return this.effects.getGrassColorOverride();
        }

        @Override
        public BiomeSpecialEffects.GrassColorModifier getGrassColorModifier() {
            return this.effects.getGrassColorModifier();
        }

        @Override
        public Optional<AmbientParticleSettings> getAmbientParticleSettings() {
            return this.effects.getAmbientParticleSettings();
        }

        @Override
        public Optional<Holder<SoundEvent>> getAmbientLoopSoundEvent() {
            return this.effects.getAmbientLoopSoundEvent();
        }

        @Override
        public Optional<AmbientMoodSettings> getAmbientMoodSettings() {
            return this.effects.getAmbientMoodSettings();
        }

        @Override
        public Optional<AmbientAdditionsSettings> getAmbientAdditionsSettings() {
            return this.effects.getAmbientAdditionsSettings();
        }

        @Override
        public Optional<WeightedList<Music>> getBackgroundMusic() {
            return this.effects.getBackgroundMusic();
        }

        @Override
        public float getBackgroundMusicVolume() {
            return this.effects.getBackgroundMusicVolume();
        }
    }

    public static abstract class MutableClimateSettingsWrapped
    extends ClimateSettingsWrapped
    implements ClimateSettings.Mutable {
        public MutableClimateSettingsWrapped(Biome biome) {
            super(biome);
        }
    }

    public static class ClimateSettingsWrapped
    implements ClimateSettings {
        private final Biome.ClimateSettings climateSettings;

        public ClimateSettingsWrapped(Biome biome) {
            this(((BiomeAccessor)biome).getClimateSettings());
        }

        public ClimateSettingsWrapped(Biome.ClimateSettings climateSettings) {
            this.climateSettings = climateSettings;
        }

        @Override
        public boolean hasPrecipitation() {
            return this.climateSettings.hasPrecipitation();
        }

        @Override
        public float getTemperature() {
            return this.climateSettings.temperature();
        }

        @Override
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.climateSettings.temperatureModifier();
        }

        @Override
        public float getDownfall() {
            return this.climateSettings.downfall();
        }
    }

    public static abstract class MutableBiomeSettingsWrapped
    extends BiomeSettingsWrapped
    implements BiomeSettings.Mutable {
        public MutableBiomeSettingsWrapped(Biome biome) {
            super(biome);
        }

        @Override
        public abstract ClimateSettings.Mutable getClimateProperties();

        @Override
        public abstract EffectsSettings.Mutable getEffectsProperties();

        @Override
        public abstract GenerationSettings.Mutable getGenerationProperties();

        @Override
        public abstract SpawnSettings.Mutable getSpawnProperties();
    }
}

