/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.network;

import com.craftjakob.network.NetworkManager;
import com.craftjakob.platform.EnvironmentType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.payload.PayloadFlow;

public final class NetworkManagerImpl {
    public static final Map<ResourceLocation, Channel<CustomPacketPayload>> CHANNELS = new HashMap<ResourceLocation, Channel<CustomPacketPayload>>();

    private NetworkManagerImpl() {
    }

    public static <T extends CustomPacketPayload, P extends Player> void register(CustomPacketPayload.Type<T> type, StreamCodec<? super FriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T, P> receiver, ConnectionProtocol protocol, PacketFlow packetFlow) {
        NetworkDirection direction = switch (protocol) {
            case ConnectionProtocol.PLAY -> {
                if (packetFlow == PacketFlow.CLIENTBOUND) {
                    yield NetworkDirection.PLAY_TO_CLIENT;
                }
                yield NetworkDirection.PLAY_TO_SERVER;
            }
            case ConnectionProtocol.CONFIGURATION -> {
                if (packetFlow == PacketFlow.CLIENTBOUND) {
                    yield NetworkDirection.CONFIGURATION_TO_CLIENT;
                }
                yield NetworkDirection.CONFIGURATION_TO_SERVER;
            }
            default -> throw new IllegalArgumentException("Unsupported protocol: " + String.valueOf(protocol));
        };
        CHANNELS.computeIfAbsent(type.id(), id -> ((PayloadFlow)ChannelBuilder.named((ResourceLocation)id).serverAcceptedVersions((status, version) -> true).clientAcceptedVersions((status, version) -> true).networkProtocolVersion(1).payloadChannel().protocol(direction.protocol()).flow(direction.direction())).add(type, codec.cast(), (payload, context) -> {
            if (context.getPacketHandled()) {
                return;
            }
            receiver.receive(payload, NetworkManagerImpl.context(context, packetFlow == PacketFlow.CLIENTBOUND));
            context.setPacketHandled(true);
        }).build());
    }

    private static <P extends Player> NetworkManager.PacketContext<P> context(final CustomPayloadEvent.Context context, final boolean client) {
        return new NetworkManager.PacketContext<P>(){

            @Override
            public P player() {
                return client ? Minecraft.getInstance().player : context.getSender();
            }

            @Override
            public void queue(Runnable runnable) {
                context.enqueueWork(runnable);
            }

            @Override
            public EnvironmentType getEnvironment() {
                return client ? EnvironmentType.CLIENT : EnvironmentType.SERVER;
            }

            @Override
            public RegistryAccess registryAccess() {
                return this.player().registryAccess();
            }

            @Override
            public PacketFlow flow() {
                return client ? PacketFlow.CLIENTBOUND : PacketFlow.SERVERBOUND;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canServerReceive(ResourceLocation id) {
        return CHANNELS.get(id) != null && Minecraft.getInstance().getConnection() != null;
    }

    public static boolean canPlayerReceive(ServerPlayer player, ResourceLocation id) {
        Channel<CustomPacketPayload> channel = CHANNELS.get(id);
        return channel != null && channel.isRemotePresent(player.connection.getConnection());
    }
}

