/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.platform;

import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Platform;
import java.util.Optional;
import java.util.function.Supplier;

public final class EnvironmentExecutor {
    private EnvironmentExecutor() {
    }

    public static void runInEnvironment(EnvironmentType type, Supplier<Runnable> runnableSupplier) {
        if (Platform.getEnvironment() == type) {
            runnableSupplier.get().run();
        }
    }

    public static <T> Optional<T> getInEnvironment(EnvironmentType type, Supplier<Supplier<T>> supplierSupplier) {
        if (Platform.getEnvironment() == type) {
            return Optional.ofNullable(supplierSupplier.get().get());
        }
        return Optional.empty();
    }

    public static <T> T getEnvironmentSpecific(Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        if (Platform.getEnvironment() == EnvironmentType.CLIENT) {
            return client.get().get();
        }
        return server.get().get();
    }
}

