/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.platform;

import com.craftjakob.configapi.ConfigAPI;
import com.craftjakob.mixin.accessor.LevelResourceAccessor;
import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Mod;
import com.craftjakob.platform.ModLoader;
import com.craftjakob.platform.PlatformHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public final class Platform {
    public static final LevelResource SERVER_CONFIG = LevelResourceAccessor.configapi$create("serverconfig");

    private Platform() {
    }

    public static EnvironmentType getEnvironment() {
        return (EnvironmentType)((Object)PlatformHelper.callPlatformMethod(new Object[0]));
    }

    public static Path getGamePath() {
        return (Path)PlatformHelper.callPlatformMethod(new Object[0]);
    }

    public static Path getModsPath() {
        return (Path)PlatformHelper.callPlatformMethod(new Object[0]);
    }

    public static Path getConfigPath() {
        return (Path)PlatformHelper.callPlatformMethod(new Object[0]);
    }

    public static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfigPath = server.getWorldPath(SERVER_CONFIG);
        if (!Files.isDirectory(serverConfigPath, new LinkOption[0])) {
            try {
                Files.createDirectories(serverConfigPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                ConfigAPI.LOGGER.error("Could not create serverconfig directory!", (Throwable)e);
            }
        }
        return serverConfigPath;
    }

    public static Mod getMod(String modId) {
        return (Mod)PlatformHelper.callPlatformMethod(modId);
    }

    public static Map<String, Mod> getMods() {
        return (Map)PlatformHelper.callPlatformMethod(new Object[0]);
    }

    public static boolean isModLoaded(String modId) {
        return (Boolean)PlatformHelper.callPlatformMethod(modId);
    }

    public static boolean isDevelopmentEnvironment() {
        return (Boolean)PlatformHelper.callPlatformMethod(new Object[0]);
    }

    public static ModLoader getModLoader() {
        return (ModLoader)((Object)PlatformHelper.callPlatformMethod(new Object[0]));
    }

    public static boolean isFabric() {
        return Platform.getModLoader().isFabric();
    }

    public static boolean isQuit() {
        return Platform.getModLoader().isQuilt();
    }

    public static boolean isForge() {
        return Platform.getModLoader().isForge();
    }

    public static boolean isNeoForge() {
        return Platform.getModLoader().isNeoForge();
    }

    public static boolean isFabricOrQuilt() {
        return Platform.isFabric() || Platform.isQuit();
    }

    public static boolean isForgeOrNeoForge() {
        return Platform.isForge() || Platform.isNeoForge();
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)PlatformHelper.callPlatformMethod(new Object[0]);
    }
}

