/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registries;

import com.craftjakob.hooks.EventBusGroupHooks;
import com.craftjakob.registration.registries.RegistryHolder;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.registries.RegisterEvent;

public final class DeferredRegisterImpl {
    private static final List<Data<?>> DATA_TO_REGISTER = new ArrayList();

    private DeferredRegisterImpl() {
    }

    public static <R> RegistryHolder<R> getRegistryHolder(String modId, ResourceKey<? extends Registry<R>> registryKey) {
        EventBusGroupHooks.ifAvailable(modId, bus -> bus.register(MethodHandles.lookup(), (Object)new EventListener(modId)));
        return new RegistryHolder(registryKey);
    }

    public static <T, E extends T> void register(RegistryHolder<T> delegate, ResourceLocation id, Supplier<E> supplier) {
        DATA_TO_REGISTER.add(new Data<T>(delegate, id, supplier));
    }

    public record Data<T>(RegistryHolder<T> registry, ResourceLocation id, Supplier<? extends T> supplier) {
    }

    public record EventListener(String modId) {
        @SubscribeEvent
        public void handleRegisterEvent(RegisterEvent event) {
            DATA_TO_REGISTER.forEach(data -> {
                if (data.registry().get() != null && data.registry().get().key().equals((Object)event.getRegistryKey())) {
                    event.register(data.registry().get().key(), helper -> helper.register(data.id(), data.supplier().get()));
                }
            });
        }
    }
}

