/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface OptionalSupplier<T>
extends Supplier<T> {
    public boolean isPresent();

    default public boolean isEmpty() {
        return !this.isPresent();
    }

    @Nullable
    default public T getOrNull() {
        return this.isPresent() ? (T)this.get() : null;
    }

    default public Optional<T> asOptional() {
        return Optional.ofNullable(this.getOrNull());
    }

    default public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.get());
        }
    }

    default public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.get());
        } else {
            emptyAction.run();
        }
    }

    default public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.empty();
    }

    default public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    default public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.get() : supplier.get();
    }
}

