/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusGroupHooks;
import com.craftjakob.registration.registries.DeferredSupplier;
import com.craftjakob.registration.registry.CreativeModeTabOutput;
import com.craftjakob.registration.registry.CreativeModeTabRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;

public final class CreativeModeTabRegistryImpl {
    private static final List<Consumer<BuildCreativeModeTabContentsEvent>> BUILD_CONTENTS_LISTENERS = new ArrayList<Consumer<BuildCreativeModeTabContentsEvent>>();

    private CreativeModeTabRegistryImpl() {
    }

    public static void modify(DeferredSupplier<CreativeModeTab> tab, CreativeModeTabRegistry.ModifyTabCallback callback) {
        BUILD_CONTENTS_LISTENERS.add(event -> {
            if (tab.isPresent() && (event.getTab().equals(tab.get()) || Objects.equals(BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)event.getTab()), tab.getId()))) {
                callback.accept(event.getParameters(), new CreativeModeTabOutput((BuildCreativeModeTabContentsEvent)event){
                    final /* synthetic */ BuildCreativeModeTabContentsEvent val$event;
                    {
                        this.val$event = buildCreativeModeTabContentsEvent;
                    }

                    @Override
                    public void acceptAfter(ItemStack after, ItemStack stack, CreativeModeTab.TabVisibility visibility) {
                        this.val$event.accept(stack, visibility);
                    }

                    @Override
                    public void acceptBefore(ItemStack before, ItemStack stack, CreativeModeTab.TabVisibility visibility) {
                        this.val$event.accept(stack, visibility);
                    }
                }, event.hasPermissions());
            }
        });
    }

    static {
        EventBusGroupHooks.ifAvailable("configapi", BuildCreativeModeTabContentsEvent::getBus, bus -> bus.addListener(event -> {
            for (Consumer<BuildCreativeModeTabContentsEvent> buildContentsListener : BUILD_CONTENTS_LISTENERS) {
                buildContentsListener.accept((BuildCreativeModeTabContentsEvent)event);
            }
        }));
    }
}

