/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.platform.PlatformHelper;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RegistryBuilder<T> {
    private final ResourceKey<Registry<T>> registryKey;
    @Nullable
    private ResourceLocation defaulted;
    private boolean sync = false;

    public RegistryBuilder(ResourceKey<Registry<T>> registryKey) {
        this.registryKey = registryKey;
    }

    public RegistryBuilder<T> defaulted(ResourceLocation defaultedId) {
        this.defaulted = defaultedId;
        return this;
    }

    public RegistryBuilder<T> sync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public WritableRegistry<T> build() {
        return this.defaulted != null ? RegistryBuilder.createDefaulted(this.registryKey, this.defaulted, this.sync) : RegistryBuilder.create(this.registryKey, this.sync);
    }

    public static <T> MappedRegistry<T> create(ResourceKey<Registry<T>> registryKey, boolean synced) {
        return (MappedRegistry)PlatformHelper.callPlatformMethod(registryKey, synced);
    }

    public static <T> DefaultedMappedRegistry<T> createDefaulted(ResourceKey<Registry<T>> registryKey, ResourceLocation defaultId, boolean synced) {
        return (DefaultedMappedRegistry)PlatformHelper.callPlatformMethod(registryKey, synced);
    }
}

