/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusGroupHooks;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public final class RegistryBuilderImpl {
    private static final List<RegistryData<?>> REGISTRY_DATA = new ArrayList();

    private RegistryBuilderImpl() {
    }

    public static <T> MappedRegistry<T> create(ResourceKey<Registry<T>> registryKey, boolean synced) {
        REGISTRY_DATA.add(new RegistryData<T>(registryKey, null, synced));
        return new MappedRegistry(registryKey, Lifecycle.stable());
    }

    public static <T> DefaultedMappedRegistry<T> createDefaulted(ResourceKey<Registry<T>> registryKey, ResourceLocation defaultId, boolean synced) {
        REGISTRY_DATA.add(new RegistryData<T>(registryKey, defaultId, synced));
        return new DefaultedMappedRegistry(defaultId.toString(), registryKey, Lifecycle.stable(), false);
    }

    static {
        EventBusGroupHooks.ifAvailable("configapi", NewRegistryEvent::getBus, group -> group.addListener(event -> {
            for (RegistryData<?> data : REGISTRY_DATA) {
                RegistryBuilder registryBuilder = new RegistryBuilder().setName(data.registryKey().location());
                if (!data.synced()) {
                    registryBuilder.disableSync();
                }
                if (data.defaultId() != null) {
                    registryBuilder.setDefaultKey(data.defaultId());
                }
                Supplier supplier = event.create(registryBuilder);
            }
        }));
    }

    private record RegistryData<T>(ResourceKey<Registry<T>> registryKey, @Nullable ResourceLocation defaultId, boolean synced) {
    }
}

