/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry;

import com.craftjakob.hooks.EventBusGroupHooks;
import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.annotation.Environment;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReloadListenerRegistryImpl {
    private static final Map<ResourceLocation, Pair<Function<// Could not load outer class - annotation placement on inner may be incorrect
    HolderLookup.Provider, PreparableReloadListener>, @Nullable Collection<ResourceLocation>>> SERVER_DATA_RELOAD_LISTENERS = new HashMap<ResourceLocation, Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<ResourceLocation>>>();

    private ReloadListenerRegistryImpl() {
    }

    @Environment(value=EnvironmentType.CLIENT)
    public static void registerClient(@NotNull ResourceLocation listenerId, PreparableReloadListener listener, @Nullable Collection<ResourceLocation> dependencies) {
        ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener(listener);
    }

    @Environment(value=EnvironmentType.SERVER)
    public static void registerServer(@NotNull ResourceLocation listenerId, Function<HolderLookup.Provider, PreparableReloadListener> listenerFunction, @Nullable Collection<ResourceLocation> dependencies) {
        SERVER_DATA_RELOAD_LISTENERS.put(listenerId, (Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<ResourceLocation>>)Pair.of(listenerFunction, dependencies));
    }

    @SubscribeEvent
    public static void addServerReloadListeners(AddReloadListenerEvent event) {
        for (Map.Entry<ResourceLocation, Pair<Function<HolderLookup.Provider, PreparableReloadListener>, Collection<ResourceLocation>>> entry : SERVER_DATA_RELOAD_LISTENERS.entrySet()) {
            Function listenerFunction = (Function)entry.getValue().getFirst();
            event.addListener((PreparableReloadListener)listenerFunction.apply(event.getRegistries()));
        }
    }

    static {
        EventBusGroupHooks.ifAvailable("configapi", bus -> bus.register(MethodHandles.lookup(), ReloadListenerRegistryImpl.class));
    }
}

