/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.client;

import com.craftjakob.hooks.EventBusGroupHooks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;

@OnlyIn(value=Dist.CLIENT)
public final class ColorHandlerRegistryImpl {
    private static final Map<BlockColor, Block[]> BLOCK_COLORS = new HashMap<BlockColor, Block[]>();

    private ColorHandlerRegistryImpl() {
    }

    public static void registerBlockColors(BlockColor color, Block ... blocks) {
        BLOCK_COLORS.put(color, blocks);
    }

    static {
        EventBusGroupHooks.ifAvailable("configapi", RegisterColorHandlersEvent.Block::getBus, bus -> bus.addListener(event -> {
            for (Map.Entry<BlockColor, Block[]> entry : BLOCK_COLORS.entrySet()) {
                event.register(entry.getKey(), entry.getValue());
            }
        }));
    }
}

