/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level;

import com.craftjakob.hooks.EventBusGroupHooks;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;

public final class EntityAttributeRegistryImpl {
    private static final Map<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> ATTRIBUTES = new ConcurrentHashMap<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>();

    private EntityAttributeRegistryImpl() {
    }

    public static void register(Supplier<? extends EntityType<? extends LivingEntity>> type, Supplier<AttributeSupplier.Builder> attribute) {
        ATTRIBUTES.put(type, attribute);
    }

    static {
        EventBusGroupHooks.ifAvailable("configapi", EntityAttributeCreationEvent::getBus, bus -> bus.addListener(event -> {
            for (Map.Entry<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> entry : ATTRIBUTES.entrySet()) {
                event.put(entry.getKey().get(), entry.getValue().get().build());
            }
        }));
    }
}

