/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level;

import com.craftjakob.hooks.EventBusGroupHooks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;

public final class SpawnPlacementsRegistryImpl {
    private static List<Entry<?>> ENTRIES = new ArrayList();

    private SpawnPlacementsRegistryImpl() {
    }

    public static <T extends Mob> void register(Supplier<? extends EntityType<T>> type, SpawnPlacementType spawnPlacement, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        if (ENTRIES == null) {
            throw new RuntimeException("The SpawnPlacementRegistry.register is called after the event was called! " + type.get().getDescriptionId());
        }
        ENTRIES.add(new Entry<T>(type, spawnPlacement, heightmapType, spawnPredicate));
    }

    static {
        EventBusGroupHooks.ifAvailable("configapi", SpawnPlacementRegisterEvent::getBus, bus -> bus.addListener(event -> {
            Iterator<Entry<?>> iterator = ENTRIES.iterator();
            while (iterator.hasNext()) {
                Entry<?> entry;
                Entry<?> casted = entry = iterator.next();
                event.register(casted.type().get(), casted.spawnPlacement(), casted.heightmapType(), casted.spawnPredicate(), SpawnPlacementRegisterEvent.Operation.OR);
            }
            ENTRIES = null;
        }));
    }

    private record Entry<T extends Mob>(Supplier<? extends EntityType<T>> type, SpawnPlacementType spawnPlacement, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
    }
}

