/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level;

import com.craftjakob.registration.registry.level.TradeRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public final class TradeRegistryImpl {
    private static final Map<ResourceKey<VillagerProfession>, Int2ObjectMap<List<VillagerTrades.ItemListing>>> VILLAGER_TRADES = new HashMap<ResourceKey<VillagerProfession>, Int2ObjectMap<List<VillagerTrades.ItemListing>>>();
    private static final List<VillagerTrades.ItemListing> WANDERER_TRADER_TRADES_SPECIAL = new ArrayList<VillagerTrades.ItemListing>();
    private static final List<VillagerTrades.ItemListing> WANDERER_TRADER_TRADES_COMMON = new ArrayList<VillagerTrades.ItemListing>();
    private static final List<VillagerTrades.ItemListing> WANDERER_TRADER_TRADES_BUYING = new ArrayList<VillagerTrades.ItemListing>();

    private TradeRegistryImpl() {
    }

    @SubscribeEvent
    public static void villageTradeEvent(VillagerTradesEvent event) {
        Int2ObjectMap<List<VillagerTrades.ItemListing>> trades = VILLAGER_TRADES.get(event.getType());
        if (trades != null) {
            for (Int2ObjectMap.Entry entry : trades.int2ObjectEntrySet()) {
                ((List)event.getTrades().computeIfAbsent(entry.getIntKey(), $ -> NonNullList.create())).addAll((Collection)entry.getValue());
            }
        }
    }

    @SubscribeEvent
    public static void wandererTraderEvent(WandererTradesEvent event) {
        if (!WANDERER_TRADER_TRADES_BUYING.isEmpty()) {
            event.getPools().add(new WandererTradesEvent.Pool(Pair.of((Object)WANDERER_TRADER_TRADES_BUYING.toArray(new VillagerTrades.ItemListing[0]), (Object)3)));
        }
        if (!WANDERER_TRADER_TRADES_COMMON.isEmpty()) {
            event.getPools().add(new WandererTradesEvent.Pool(Pair.of((Object)WANDERER_TRADER_TRADES_COMMON.toArray(new VillagerTrades.ItemListing[0]), (Object)2)));
        }
        if (!WANDERER_TRADER_TRADES_SPECIAL.isEmpty()) {
            event.getPools().add(new WandererTradesEvent.Pool(Pair.of((Object)WANDERER_TRADER_TRADES_SPECIAL.toArray(new VillagerTrades.ItemListing[0]), (Object)1)));
        }
    }

    public static void registerVillagerTrade(ResourceKey<VillagerProfession> professionKey, int level, VillagerTrades.ItemListing ... trades) {
        Int2ObjectMap tradesForProfession = VILLAGER_TRADES.computeIfAbsent(professionKey, $ -> new Int2ObjectOpenHashMap());
        List tradesForLevel = (List)tradesForProfession.computeIfAbsent(level, $ -> new ArrayList());
        Collections.addAll(tradesForLevel, trades);
    }

    public static void registerTradeForWanderingTrader(TradeRegistry.WandererTradeType type, VillagerTrades.ItemListing ... trades) {
        switch (type) {
            case BUYING_TRADES: {
                Collections.addAll(WANDERER_TRADER_TRADES_SPECIAL, trades);
                break;
            }
            case COMMON_TRADES: {
                Collections.addAll(WANDERER_TRADER_TRADES_COMMON, trades);
                break;
            }
            case SPECIAL_TRADES: {
                Collections.addAll(WANDERER_TRADER_TRADES_BUYING, trades);
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(TradeRegistryImpl.class);
    }
}

