/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.level.biome;

import com.craftjakob.hooks.EventBusGroupHooks;
import com.craftjakob.hooks.level.biome.BiomeHooks;
import com.craftjakob.hooks.level.biome.BiomeSettings;
import com.craftjakob.hooks.level.biome.ClimateSettings;
import com.craftjakob.hooks.level.biome.EffectsSettings;
import com.craftjakob.hooks.level.biome.GenerationSettings;
import com.craftjakob.hooks.level.biome.SpawnSettings;
import com.craftjakob.mixin.forge.accessor.MobSpawnSettingsBuilderAccessor;
import com.craftjakob.mixin.forge.accessor.PlainBuilderAccessor;
import com.craftjakob.platform.Platform;
import com.craftjakob.registration.registry.level.biome.BiomeModificationRegistry;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BiomeModificationRegistryImpl {
    private static final EnumMap<BiomeModificationRegistry.ModificationPhase, List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>>> MODIFICATIONS = new EnumMap(BiomeModificationRegistry.ModificationPhase.class);

    private BiomeModificationRegistryImpl() {
    }

    public static void putModification(BiomeModificationRegistry.ModificationPhase phase, BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable> modifier) {
        MODIFICATIONS.get((Object)phase).add(modifier);
    }

    private static BiomeModificationRegistry.BiomeContext wrapBiomeContext(final Holder<Biome> biomeHolder) {
        return new BiomeModificationRegistry.BiomeContext(){
            final Biome biome;
            final BiomeSettings biomeSettings;
            {
                this.biome = (Biome)biomeHolder.value();
                this.biomeSettings = BiomeHooks.getBiomeSettings(this.biome);
            }

            @Override
            public Biome getBiome() {
                return this.biome;
            }

            @Override
            public Holder<Biome> getBiomeHolder() {
                return biomeHolder;
            }

            @Override
            public ResourceKey<Biome> getBiomeKey() {
                return biomeHolder.unwrapKey().orElse(null);
            }

            @Override
            public BiomeSettings getBiomeSettings() {
                return this.biomeSettings;
            }

            @Override
            public boolean hasTag(TagKey<Biome> tag) {
                return this.getBiomeHolder().is(tag);
            }

            @Override
            public boolean canGenerateIn(ResourceKey<LevelStem> dimensionKey) {
                LevelStem dimension = (LevelStem)Platform.getServer().registryAccess().lookupOrThrow(Registries.LEVEL_STEM).getValue(dimensionKey);
                return dimension != null && dimension.generator().getBiomeSource().possibleBiomes().contains(this.getBiomeHolder());
            }
        };
    }

    private static BiomeSettings.Mutable wrapMutableBiomeSettings(Holder<Biome> biomeHolder, final ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        final Biome biome = (Biome)biomeHolder.value();
        return new BiomeHooks.MutableBiomeSettingsWrapped(biome){

            @Override
            public ClimateSettings.Mutable getClimateProperties() {
                return new BiomeHooks.MutableClimateSettingsWrapped(biome){

                    @Override
                    public ClimateSettings.Mutable setHasPrecipitation(boolean hasPrecipitation) {
                        builder.getClimateSettings().setHasPrecipitation(hasPrecipitation);
                        return this;
                    }

                    @Override
                    public ClimateSettings.Mutable setTemperature(float temperature) {
                        builder.getClimateSettings().setTemperature(temperature);
                        return this;
                    }

                    @Override
                    public ClimateSettings.Mutable setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
                        builder.getClimateSettings().setTemperatureModifier(temperatureModifier);
                        return this;
                    }

                    @Override
                    public ClimateSettings.Mutable setDownfall(float downfall) {
                        builder.getClimateSettings().setDownfall(downfall);
                        return this;
                    }
                };
            }

            @Override
            public EffectsSettings.Mutable getEffectsProperties() {
                return new BiomeHooks.MutableEffectsSettingsWrapped(biome){

                    @Override
                    public EffectsSettings.Mutable setFogColor(int fogColor) {
                        builder.getSpecialEffects().fogColor(fogColor);
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setWaterColor(int waterColor) {
                        builder.getSpecialEffects().waterColor(waterColor);
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setWaterFogColor(int waterFogColor) {
                        builder.getSpecialEffects().waterFogColor(waterFogColor);
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setSkyColor(int skyColor) {
                        builder.getSpecialEffects().skyColor(skyColor);
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setFoliageColorOverride(Optional<Integer> foliageColorOverride) {
                        foliageColorOverride.ifPresent(color -> builder.getSpecialEffects().foliageColorOverride(color.intValue()));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setDryFoliageColorOverride(Optional<Integer> dryFoliageColorOverride) {
                        dryFoliageColorOverride.ifPresent(color -> builder.getSpecialEffects().dryFoliageColorOverride(color.intValue()));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setGrassColorOverride(Optional<Integer> grassColorOverride) {
                        grassColorOverride.ifPresent(color -> builder.getSpecialEffects().grassColorOverride(color.intValue()));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setGrassColorModifier(BiomeSpecialEffects.GrassColorModifier grassColorModifier) {
                        builder.getSpecialEffects().grassColorModifier(grassColorModifier);
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setAmbientParticleSettings(Optional<AmbientParticleSettings> ambientParticleSettings) {
                        ambientParticleSettings.ifPresent(settings -> builder.getSpecialEffects().ambientParticle(settings));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setAmbientLoopSoundEvent(Holder<SoundEvent> ambientLoopSoundEvent) {
                        builder.getSpecialEffects().ambientLoopSound(ambientLoopSoundEvent);
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setAmbientMoodSettings(Optional<AmbientMoodSettings> ambientMoodSettings) {
                        ambientMoodSettings.ifPresent(settings -> builder.getSpecialEffects().ambientMoodSound(settings));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setAmbientAdditionsSettings(Optional<AmbientAdditionsSettings> ambientAdditionsSettings) {
                        ambientAdditionsSettings.ifPresent(settings -> builder.getSpecialEffects().ambientAdditionsSound(settings));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setBackgroundMusic(Optional<WeightedList<Music>> backgroundMusic) {
                        backgroundMusic.ifPresent(music -> builder.getSpecialEffects().backgroundMusic(music));
                        return this;
                    }

                    @Override
                    public EffectsSettings.Mutable setBackgroundMusicVolume(float backgroundMusicVolume) {
                        builder.getSpecialEffects().backgroundMusicVolume(backgroundMusicVolume);
                        return this;
                    }
                };
            }

            @Override
            public GenerationSettings.Mutable getGenerationProperties() {
                return new BiomeHooks.MutableGenerationSettingsWrapped(biome){

                    @Override
                    public GenerationSettings.Mutable addFeature(GenerationStep.Decoration decoration, Holder<PlacedFeature> placedFeatureHolder) {
                        builder.getGenerationSettings().addFeature(decoration, placedFeatureHolder);
                        return this;
                    }

                    @Override
                    public GenerationSettings.Mutable addFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> placedFeatureKey) {
                        Optional registry;
                        MinecraftServer server = Platform.getServer();
                        if (server != null && (registry = server.registryAccess().lookup(Registries.PLACED_FEATURE)).isPresent()) {
                            Optional holder = ((Registry)registry.get()).get(placedFeatureKey);
                            if (holder.isPresent()) {
                                return this.addFeature(decoration, (Holder<PlacedFeature>)((Holder)holder.get()));
                            }
                            throw new IllegalArgumentException("Unknown feature: " + String.valueOf(placedFeatureKey));
                        }
                        return this;
                    }

                    @Override
                    public GenerationSettings.Mutable addCarver(Holder<ConfiguredWorldCarver<?>> worldCarverHolder) {
                        builder.getGenerationSettings().addCarver(worldCarverHolder);
                        return this;
                    }

                    @Override
                    public GenerationSettings.Mutable addCarver(ResourceKey<ConfiguredWorldCarver<?>> worldCarverKey) {
                        Optional registry;
                        MinecraftServer server = Platform.getServer();
                        if (server != null && (registry = server.registryAccess().lookup(Registries.CONFIGURED_CARVER)).isPresent()) {
                            Optional holder = ((Registry)registry.get()).get(worldCarverKey);
                            if (holder.isPresent()) {
                                return this.addCarver((Holder)holder.get());
                            }
                            throw new IllegalArgumentException("Unknown carver: " + String.valueOf(worldCarverKey));
                        }
                        return this;
                    }

                    @Override
                    public GenerationSettings.Mutable removeFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> placedFeatureKey) {
                        builder.getGenerationSettings().getFeatures(decoration).removeIf(holder -> holder.is(placedFeatureKey));
                        return this;
                    }

                    @Override
                    public GenerationSettings.Mutable removeCarver(ResourceKey<ConfiguredWorldCarver<?>> worldCarverKey) {
                        ((PlainBuilderAccessor)builder.getGenerationSettings()).getCarvers().removeIf(holder -> holder.is(worldCarverKey));
                        return this;
                    }
                };
            }

            @Override
            public SpawnSettings.Mutable getSpawnProperties() {
                return new BiomeHooks.MutableSpawnSettingsWrapped(biome){

                    @Override
                    public SpawnSettings.Mutable setCreatureProbability(float creatureProbability) {
                        builder.getMobSpawnSettings().creatureGenerationProbability(creatureProbability);
                        return this;
                    }

                    @Override
                    public SpawnSettings.Mutable addSpawn(MobCategory mobCategory, MobSpawnSettings.SpawnerData spawnerData, int weight) {
                        builder.getMobSpawnSettings().addSpawn(mobCategory, weight, spawnerData);
                        return this;
                    }

                    @Override
                    public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> predicate) {
                        boolean removed = false;
                        Map<MobCategory, WeightedList.Builder<MobSpawnSettings.SpawnerData>> spawners = ((MobSpawnSettingsBuilderAccessor)builder.getMobSpawnSettings()).getSpawners();
                        for (MobCategory category : builder.getMobSpawnSettings().getSpawnerTypes()) {
                            WeightedList.Builder<MobSpawnSettings.SpawnerData> builder = spawners.get(category);
                            List entries = builder.build().unwrap();
                            int originalSize = entries.size();
                            WeightedList.Builder newBuilder = WeightedList.builder();
                            for (Weighted entry : entries) {
                                if (predicate.test(category, (MobSpawnSettings.SpawnerData)entry.value())) continue;
                                newBuilder.add((Object)((MobSpawnSettings.SpawnerData)entry.value()), entry.weight());
                            }
                            if (newBuilder.build().unwrap().size() >= originalSize) continue;
                            spawners.put(category, (WeightedList.Builder<MobSpawnSettings.SpawnerData>)newBuilder);
                            removed = true;
                        }
                        return removed;
                    }

                    @Override
                    public SpawnSettings.Mutable setSpawnCost(EntityType<?> entityType, MobSpawnSettings.MobSpawnCost mobSpawnCost) {
                        builder.getMobSpawnSettings().addMobCharge(entityType, mobSpawnCost.charge(), mobSpawnCost.energyBudget());
                        return this;
                    }

                    @Override
                    public SpawnSettings.Mutable setSpawnCost(EntityType<?> entityType, double charge, double energyBudget) {
                        builder.getMobSpawnSettings().addMobCharge(entityType, charge, energyBudget);
                        return this;
                    }

                    @Override
                    public SpawnSettings.Mutable clearSpawnCost(EntityType<?> entityType) {
                        this.getMobSpawnCosts().remove(entityType);
                        return this;
                    }
                };
            }
        };
    }

    static {
        for (BiomeModificationRegistry.ModificationPhase phase : BiomeModificationRegistry.ModificationPhase.values()) {
            MODIFICATIONS.put(phase, new ArrayList());
        }
        EventBusGroupHooks.ifAvailable("configapi", RegisterEvent::getBus, bus -> bus.addListener(event -> event.register(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, helper -> helper.register(ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)"none_biome_mod_codec"), BiomeModifierImpl.INSTANCE.codec()))));
    }

    public static class BiomeModifierImpl
    implements BiomeModifier {
        private static final BiomeModifierImpl INSTANCE = new BiomeModifierImpl();
        @Nullable
        private static MapCodec<? extends BiomeModifier> NONE_BIOME_MOD_CODEC = null;

        private BiomeModifierImpl() {
        }

        public void modify(@NotNull Holder<Biome> holder, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>> consumers;
            switch (phase) {
                case ADD: {
                    List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>> list = MODIFICATIONS.get((Object)BiomeModificationRegistry.ModificationPhase.ADD);
                    break;
                }
                case REMOVE: {
                    List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>> list = MODIFICATIONS.get((Object)BiomeModificationRegistry.ModificationPhase.REMOVE);
                    break;
                }
                case MODIFY: {
                    List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>> list = MODIFICATIONS.get((Object)BiomeModificationRegistry.ModificationPhase.REPLACE);
                    break;
                }
                case AFTER_EVERYTHING: {
                    List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>> list = MODIFICATIONS.get((Object)BiomeModificationRegistry.ModificationPhase.POST_PROCESS);
                    break;
                }
                default: {
                    List<BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable>> list = consumers = null;
                }
            }
            if (consumers == null) {
                return;
            }
            BiomeModificationRegistry.BiomeContext biomeContext = BiomeModificationRegistryImpl.wrapBiomeContext(holder);
            BiomeSettings.Mutable mutableBiomeProperties = BiomeModificationRegistryImpl.wrapMutableBiomeSettings(holder, builder);
            for (BiConsumer<BiomeModificationRegistry.BiomeContext, BiomeSettings.Mutable> consumer : consumers) {
                consumer.accept(biomeContext, mutableBiomeProperties);
            }
        }

        @NotNull
        public MapCodec<? extends BiomeModifier> codec() {
            return Objects.requireNonNullElseGet(NONE_BIOME_MOD_CODEC, () -> {
                NONE_BIOME_MOD_CODEC = MapCodec.unit((Object)INSTANCE);
                return NONE_BIOME_MOD_CODEC;
            });
        }
    }
}

