/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.menu;

import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.PlatformHelper;
import com.craftjakob.platform.annotation.Environment;
import com.craftjakob.registration.registry.menu.ExtendedMenuProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MenuRegistry {
    private MenuRegistry() {
    }

    public static void openExtendedMenu(ServerPlayer player, final MenuProvider provider, final Consumer<RegistryFriendlyByteBuf> bufConsumer) {
        MenuRegistry.openExtendedMenu(player, new ExtendedMenuProvider(){

            @Override
            public void saveExtraData(RegistryFriendlyByteBuf extraData) {
                bufConsumer.accept(extraData);
            }

            @NotNull
            public Component getDisplayName() {
                return provider.getDisplayName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
                return provider.createMenu(i, inventory, player);
            }
        });
    }

    public static void openExtendedMenu(ServerPlayer player, ExtendedMenuProvider provider) {
        PlatformHelper.callPlatformMethod(player, provider);
    }

    public static void openMenu(ServerPlayer player, MenuProvider provider) {
        player.openMenu(provider);
    }

    public static <M extends AbstractContainerMenu> MenuType<M> of(ExtendedMenuTypeFactory<M> factory) {
        return (MenuType)PlatformHelper.callPlatformMethod(factory);
    }

    @Environment(value=EnvironmentType.CLIENT)
    public static <M extends AbstractContainerMenu, S extends Screen> void registerScreenFactory(MenuType<? extends M> type, ScreenFactory<M, S> factory) {
        PlatformHelper.callPlatformMethod(type, factory);
    }

    @FunctionalInterface
    @Environment(value=EnvironmentType.CLIENT)
    public static interface ScreenFactory<M extends AbstractContainerMenu, S extends Screen> {
        public S create(M var1, Inventory var2, Component var3);
    }

    @FunctionalInterface
    public static interface ExtendedMenuTypeFactory<M extends AbstractContainerMenu> {
        public M create(int var1, Inventory var2, RegistryFriendlyByteBuf var3);
    }
}

