/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.registration.registry.menu;

import com.craftjakob.registration.registry.menu.ExtendedMenuProvider;
import com.craftjakob.registration.registry.menu.MenuRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;

public final class MenuRegistryImpl {
    private MenuRegistryImpl() {
    }

    public static void openExtendedMenu(ServerPlayer player, ExtendedMenuProvider provider) {
        player.openMenu((MenuProvider)provider, friendlyByteBuf -> {
            if (friendlyByteBuf instanceof RegistryFriendlyByteBuf) {
                RegistryFriendlyByteBuf registryFriendlyByteBuf = (RegistryFriendlyByteBuf)friendlyByteBuf;
                provider.saveExtraData(registryFriendlyByteBuf);
            } else {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)friendlyByteBuf, player.registryAccess());
                provider.saveExtraData(buf);
            }
        });
    }

    public static <T extends AbstractContainerMenu> MenuType<T> ofExtended(MenuRegistry.ExtendedMenuTypeFactory<T> factory) {
        return IForgeMenuType.create((windowId, inv, data) -> factory.create(windowId, inv, new RegistryFriendlyByteBuf((ByteBuf)data, inv.player.registryAccess())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends AbstractContainerMenu, S extends Screen> void registerScreenFactory(MenuType<? extends M> type, MenuRegistry.ScreenFactory<M, S> factory) {
        MenuScreens.register(type, factory::create);
    }
}

