/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.api;

import net.minecraft.resources.ResourceLocation;

public final class SimpleResourceLocation {
    private final String nameSpace;
    private final String path;

    public SimpleResourceLocation(ResourceLocation resourceLocation) {
        this.nameSpace = resourceLocation.getNamespace();
        this.path = resourceLocation.getPath();
    }

    public SimpleResourceLocation(String nameSpace, String path) {
        this.nameSpace = nameSpace;
        this.path = path;
    }

    public SimpleResourceLocation(String pathOrResourceLocation) {
        if (pathOrResourceLocation.contains(":")) {
            String[] parts = pathOrResourceLocation.split(":");
            this.nameSpace = parts[0];
            this.path = parts[1];
        } else {
            this.nameSpace = "minecraft";
            this.path = pathOrResourceLocation;
        }
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getPath() {
        return this.path;
    }

    public ResourceLocation get() {
        return SimpleResourceLocation.location(this.getNameSpace(), this.getPath());
    }

    public String toString() {
        return this.getNameSpace() + ":" + this.getPath();
    }

    public static ResourceLocation location(String nameSpace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)path);
    }

    public static ResourceLocation location(String pathOrResourceLocation) {
        if (pathOrResourceLocation.contains(":")) {
            return ResourceLocation.parse((String)pathOrResourceLocation);
        }
        return ResourceLocation.withDefaultNamespace((String)pathOrResourceLocation);
    }
}

