/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen;

import com.craftjakob.configapi.client.ConfigScreenUtils;
import com.craftjakob.configapi.client.screen.EnumConfigScreen;
import com.craftjakob.configapi.client.screen.ListConfigScreen;
import com.craftjakob.configapi.client.screen.ModScreen;
import com.craftjakob.configapi.client.screen.list.ValueList;
import com.craftjakob.configapi.client.screen.widget.CheckBoxButton;
import com.craftjakob.configapi.client.screen.widget.ConfigEditBox;
import com.craftjakob.configapi.client.screen.widget.ImageTextButton;
import com.craftjakob.configapi.client.screen.widget.SearchBox;
import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.config.ConfigData;
import com.craftjakob.configapi.config.ConfigValueTypes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends ModScreen {
    private ConfigScreenList list;
    private Button doneButton;
    private SearchBox searchBox;
    protected final Config config;
    private List<ConfigScreenList.Entry> allEntries;
    protected final ConfigData configData;
    protected final int categoryLevel;
    private final String modDisplayName;
    private CheckBoxButton checkBox;
    protected boolean deepSearch = false;

    public ConfigScreen(ModScreen lastScreen, Component title, String modDisplayName, Config config, int categoryLevel) {
        super(lastScreen, title, lastScreen.getLogoLocation());
        this.modDisplayName = modDisplayName;
        this.config = config;
        this.categoryLevel = categoryLevel;
        this.configData = config.getConfigData();
    }

    @Override
    protected void init() {
        this.list = new ConfigScreenList(25);
        this.addWidget((GuiEventListener)this.list);
        this.allEntries = new ArrayList<ConfigScreenList.Entry>(this.list.children());
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.doneButton);
        this.searchBox = new SearchBox(this.font, this.width / 2 - 150, this.height - 27, 150, 20);
        this.addWidget((GuiEventListener)this.searchBox);
        this.searchBox.setResponder(this::updateList);
        this.checkBox = new CheckBoxButton(this.width / 2 - 170, this.height - 27, button -> {
            this.deepSearch = !this.deepSearch;
            this.list.children().clear();
            this.allEntries.clear();
            if (this.deepSearch) {
                for (ConfigValueTypes.ConfigValue<?> config : this.configData.getConfigValues().values()) {
                    List<String> folderPath = config.getPath().subList(0, config.getPath().size() - 1);
                    if (folderPath.size() < this.categoryLevel || !folderPath.toString().contains(this.getTitle().getString().replace("[", "").replace("]", ""))) continue;
                    this.list.addConfigToEntry(config);
                }
            } else {
                this.list.addCategorizedConfigsToEntry();
            }
            this.allEntries.addAll(this.list.children());
            this.list.setScrollAmount(0.0);
        });
        this.addWidget((GuiEventListener)this.checkBox);
        this.checkBox.setChecked(this.deepSearch);
        super.init();
    }

    public void updateList(String searchText) {
        this.searchBox.updateSearchTextFieldSuggestion(this.searchBox, searchText, this.allEntries);
        ArrayList<ConfigScreenList.Entry> matchingEntries = new ArrayList<ConfigScreenList.Entry>();
        if (searchText.toLowerCase().startsWith("#")) {
            String tooltipSearch = searchText.replaceFirst("#", "");
            for (ConfigScreenList.Entry entry : this.allEntries) {
                if (!entry.tooltipText.getString().toLowerCase().contains(tooltipSearch.toLowerCase())) continue;
                matchingEntries.add(entry);
            }
        }
        for (ConfigScreenList.Entry entry : this.allEntries) {
            if (!entry.getEntryName().toLowerCase().contains(searchText.toLowerCase())) continue;
            matchingEntries.add(entry);
        }
        this.list.children().clear();
        this.list.children().addAll(matchingEntries);
        this.list.setScrollAmount(0.0);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.doneButton.render(graphics, mouseX, mouseY, partialTicks);
        this.searchBox.render(graphics, mouseX, mouseY, partialTicks);
        this.checkBox.render(graphics, mouseX, mouseY, partialTicks);
    }

    public class ConfigScreenList
    extends ValueList<Entry> {
        public ConfigScreenList(int buttonSpacing) {
            super(ConfigScreen.this.minecraft, ConfigScreen.this.width, ConfigScreen.this.height - 64, 32, buttonSpacing);
            this.addCategorizedConfigsToEntry();
        }

        public void addCategorizedConfigsToEntry() {
            HashSet<String> addedFolders = new HashSet<String>();
            for (ConfigValueTypes.ConfigValue<?> config : ConfigScreen.this.configData.getConfigValues().values()) {
                String folderName;
                List<String> folderPath = config.getPath().subList(0, config.getPath().size() - 1);
                if (folderPath.size() == ConfigScreen.this.categoryLevel) {
                    if (ConfigScreen.this.categoryLevel != 0 && !folderPath.toString().contains(ConfigScreen.this.getTitle().getString().replace("[", "").replace("]", ""))) continue;
                    this.addConfigToEntry(config);
                    continue;
                }
                if (folderPath.size() != ConfigScreen.this.categoryLevel + 1 || addedFolders.contains(folderName = folderPath.get(ConfigScreen.this.categoryLevel)) || ConfigScreen.this.categoryLevel != 0 && !folderPath.toString().contains(ConfigScreen.this.getTitle().getString().replace("[", "").replace("]", ""))) continue;
                this.addEntry((AbstractSelectionList.Entry)new CategoryEntry(folderName, folderPath, ConfigScreen.this.categoryLevel));
                addedFolders.add(folderName);
            }
        }

        public <T extends Number, E extends Enum<E>> void addConfigToEntry(ConfigValueTypes.ConfigValue<?> config) {
            Object value = config.getValue();
            if (value instanceof Boolean) {
                this.addEntry((AbstractSelectionList.Entry)new BooleanEntry(this, config));
            } else if (value instanceof Enum) {
                this.addEntry((AbstractSelectionList.Entry)new EnumEntry(config));
            } else if (value instanceof List) {
                this.addEntry((AbstractSelectionList.Entry)new ListEntry((ConfigValueTypes.ConfigValue<List<?>>)config));
            } else if (config instanceof ConfigValueTypes.NumberValue) {
                this.addEntry((AbstractSelectionList.Entry)new NumberValueEntry<Boolean>(this, config));
            } else {
                this.addEntry((AbstractSelectionList.Entry)new ConfigValueEntry<Boolean>(this, config));
            }
        }

        public int getRowWidth() {
            return this.width;
        }

        public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            Entry entry = (Entry)this.getHovered();
            if (entry != null && entry.tooltip != null) {
                ConfigScreen.this.setTooltipForNextRenderPass(entry.tooltipText);
            }
        }

        public class CategoryEntry
        extends Entry {
            private final Button button;

            public CategoryEntry(String categoryName, List<String> folderPath, int categoryLevel) {
                super(categoryName, ConfigScreenUtils.createTooltipTextForCategory(ConfigScreen.this.configData, categoryName, folderPath));
                this.button = new ImageTextButton(0, 0, 0, 20, (Component)Component.literal((String)categoryName).withStyle(ChatFormatting.BOLD), ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/folder.png"), 20, 20, button -> {
                    ConfigScreen newScreen = new ConfigScreen(ConfigScreen.this, (Component)Component.literal((String)categoryName), ConfigScreen.this.modDisplayName, ConfigScreen.this.config, categoryLevel + 1);
                    Objects.requireNonNull(ConfigScreen.this.minecraft).setScreen((Screen)newScreen);
                });
                this.children.add(this.button);
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                this.button.setWidth(entryRight - 150);
                this.button.setPosition(entryLeft + 75, entryTop);
                this.button.render(graphics, mouseX, mouseY, partialTicks);
            }

            @Override
            public void refreshEntry() {
            }
        }

        public class BooleanEntry
        extends ConfigEntry {
            private final CycleButton<Boolean> button;

            public BooleanEntry(ConfigScreenList this$1, ConfigValueTypes.ConfigValue<Boolean> config) {
                super(config);
                this.button = CycleButton.booleanBuilder((Component)Component.literal((String)"true").withStyle(ChatFormatting.GREEN), (Component)Component.literal((String)"false").withStyle(ChatFormatting.RED)).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.literal((String)config.getKey()), (button, newValue) -> config.setValue((Boolean)newValue));
                this.refreshEntry();
                this.resetButton = ConfigScreenUtils.createIconResetButton(config, this.button);
                this.children.add(this.button);
                this.children.add(this.resetButton);
                this.widget = this.button;
            }

            @Override
            public void refreshEntry() {
                this.button.setValue((Object)((Boolean)this.config.getValue()));
            }
        }

        public class EnumEntry<E extends Enum<E>>
        extends ConfigEntry {
            private final CycleButton<E> button;
            private final Button enumEditButton;

            public EnumEntry(ConfigValueTypes.ConfigValue<Enum<E>> config) {
                super(config);
                EnumSet<E> values = EnumSet.allOf(config.getDefaultValue().getDeclaringClass());
                this.button = CycleButton.builder(value -> Component.literal((String)value.name())).withValues(values).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.literal((String)config.getKey()), (button, newValue) -> config.setValue((Enum)newValue));
                this.refreshEntry();
                this.enumEditButton = ConfigScreenUtils.createEditButton(button -> {
                    EnumConfigScreen newScreen = new EnumConfigScreen(ConfigScreen.this, config, newValue -> ConfigScreen.this.config.setValue(config.getKey(), newValue));
                    Objects.requireNonNull(ConfigScreenList.this.minecraft).setScreen(newScreen);
                });
                this.resetButton = ConfigScreenUtils.createIconResetButton(config, this.button);
                this.children.add(this.button);
                this.children.add(this.enumEditButton);
                this.children.add(this.resetButton);
                this.widget = this.button;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                this.enumEditButton.setPosition(entryRight - 215, entryTop);
                this.enumEditButton.render(graphics, mouseX, mouseY, partialTicks);
            }

            @Override
            public void refreshEntry() {
                this.button.setValue((Object)((Enum)ConfigScreen.this.config.getValue(this.config.getKey())));
            }
        }

        public class ListEntry
        extends ConfigEntry {
            private final Button editListButton;
            private final ConfigEditBox<?> editBox;

            public ListEntry(ConfigValueTypes.ConfigValue<List<?>> config) {
                super(config);
                this.editListButton = ConfigScreenUtils.createEditButton(button -> {
                    ListConfigScreen newScreen = new ListConfigScreen(ConfigScreen.this, config, newValues -> ConfigScreen.this.config.setValue(config.getKey(), newValues));
                    Objects.requireNonNull(ConfigScreenList.this.minecraft).setScreen((Screen)newScreen);
                });
                this.editBox = new ConfigEditBox(ConfigScreen.this.font, 0, 0, 100, 20, config);
                this.refreshEntry();
                this.editBox.setResponder(newValue -> ConfigScreen.this.config.setValue(config.getKey(), newValue));
                this.resetButton = ConfigScreenUtils.createIconResetButton(button -> {
                    ConfigScreen.this.config.setValue(config.getKey(), (List)config.getDefaultValue());
                    this.refreshEntry();
                });
                this.children.add(this.editListButton);
                this.children.add(this.editBox);
                this.children.add(this.resetButton);
                this.widget = this.editBox;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                this.editListButton.setPosition(entryRight - 215, entryTop);
                this.editListButton.render(graphics, mouseX, mouseY, partialTicks);
            }

            @Override
            public void refreshEntry() {
                this.editBox.setValue(((List)this.config.getValue()).stream().map(Object::toString).collect(Collectors.joining(", ")));
            }
        }

        public class NumberValueEntry<T extends Number>
        extends ConfigEntry {
            private final ConfigEditBox<T> editBox;

            public NumberValueEntry(ConfigScreenList this$1, ConfigValueTypes.ConfigValue<T> config) {
                super(config);
                this.editBox = new ConfigEditBox<T>(this$1.ConfigScreen.this.font, 0, 0, 100, 20, config);
                this.refreshEntry();
                this.editBox.setResponder(newValue -> {
                    try {
                        ConfigValueTypes.NumberValue numberConfig;
                        Number value = (Number)config.getParser().apply((String)newValue);
                        if (config instanceof ConfigValueTypes.NumberValue && !(numberConfig = (ConfigValueTypes.NumberValue)config).isInRange(value)) {
                            throw new Exception();
                        }
                        config.setValue(value);
                        this.valid = true;
                        this.editBox.setValid(true);
                    }
                    catch (Exception e) {
                        this.valid = false;
                        this.editBox.setValid(false);
                    }
                });
                this.resetButton = ConfigScreenUtils.createIconResetButton(config, this.editBox);
                this.children.add(this.editBox);
                this.children.add(this.resetButton);
                this.widget = this.editBox;
            }

            @Override
            public void refreshEntry() {
                this.editBox.setValue(this.config.getValue().toString());
            }
        }

        public class ConfigValueEntry<T>
        extends ConfigEntry {
            private final ConfigEditBox<T> editBox;

            public ConfigValueEntry(ConfigScreenList this$1, ConfigValueTypes.ConfigValue<T> config) {
                super(config);
                this.editBox = new ConfigEditBox<T>(this$1.ConfigScreen.this.font, 0, 0, 100, 20, config);
                this.refreshEntry();
                this.editBox.setResponder(newValue -> {
                    try {
                        Object value = config.getParser().apply((String)newValue);
                        config.setValue(value);
                        this.valid = true;
                        this.editBox.setValid(true);
                    }
                    catch (Exception e) {
                        this.valid = false;
                        this.editBox.setValid(false);
                    }
                });
                this.resetButton = ConfigScreenUtils.createIconResetButton(config, this.editBox);
                this.children.add(this.editBox);
                this.children.add(this.resetButton);
                this.widget = this.editBox;
            }

            @Override
            public void refreshEntry() {
                this.editBox.setValue(this.config.getValue().toString());
            }
        }

        public static abstract class Entry
        extends ValueList.Entry<Entry> {
            public final Component tooltipText;
            public final Tooltip tooltip;

            public Entry(String entryName, Component tooltipText) {
                super(entryName);
                this.tooltipText = tooltipText;
                this.tooltip = Tooltip.create((Component)this.tooltipText);
            }
        }

        public abstract class ConfigEntry
        extends Entry {
            public Button resetButton;
            public AbstractWidget widget;
            public boolean valid;
            public final ConfigValueTypes.ConfigValue<?> config;

            public ConfigEntry(ConfigValueTypes.ConfigValue<?> config) {
                super(ConfigScreenUtils.addSpaceAfterCapitalLetter(config.getKey()), ConfigScreenUtils.createTooltipText(config));
                this.resetButton = null;
                this.widget = null;
                this.valid = true;
                this.config = config;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                if (this.resetButton != null) {
                    this.resetButton.setPosition(entryRight - 95, entryTop);
                    this.resetButton.render(graphics, mouseX, mouseY, partialTicks);
                    boolean bl = this.resetButton.active = !this.config.isDefaultValue();
                }
                if (this.widget != null) {
                    this.widget.setPosition(entryRight - 195, entryTop);
                    this.widget.render(graphics, mouseX, mouseY, partialTicks);
                    if (this.valid) {
                        graphics.drawString(ConfigScreen.this.font, this.getEntryName(), entryLeft + 75, entryTop + this.widget.getHeight() / 2 - 3, 0xFFFFFF);
                    } else {
                        graphics.drawString(ConfigScreen.this.font, (Component)Component.literal((String)this.getEntryName()).withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC}), entryLeft + 75, entryTop + this.widget.getHeight() / 2 - 3, 0xFFFFFF);
                    }
                }
            }

            @Override
            public abstract void refreshEntry();
        }
    }
}

