/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen;

import com.craftjakob.configapi.client.ConfigScreenUtils;
import com.craftjakob.configapi.client.screen.ConfigScreen;
import com.craftjakob.configapi.client.screen.ConfigWorldSelectionScreen;
import com.craftjakob.configapi.client.screen.ModScreen;
import com.craftjakob.configapi.client.screen.list.ModObjectSelectionList;
import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.example.ClientConfig;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConfigTypeSelectionScreen
extends ModScreen {
    private final Map<Config.ConfigType, LinkedHashSet<Config>> configs;
    private ConfigTypeSelectionList list;
    private Button openFileButton;
    private Button doneButton;

    public ConfigTypeSelectionScreen(Screen lastScreen, ResourceLocation logoLocation, Component title, Map<Config.ConfigType, LinkedHashSet<Config>> configs) {
        super(lastScreen, title, logoLocation);
        this.configs = configs;
    }

    @Override
    protected void init() {
        this.list = new ConfigTypeSelectionList(40);
        this.addWidget((GuiEventListener)this.list);
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.doneButton);
        this.openFileButton = Button.builder((Component)Component.literal((String)"Open Config File"), button -> {
            ConfigTypeSelectionList.Entry selected = (ConfigTypeSelectionList.Entry)this.list.getSelected();
            if (selected != null) {
                if (!selected.config.getConfigFile().exists()) {
                    selected.config.save();
                }
                Style style = Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenFile(selected.config.getConfigFile()));
                this.handleComponentClicked(style);
            }
        }).bounds(this.width / 2 - 150, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.openFileButton);
        super.init();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.doneButton.render(graphics, mouseX, mouseY, partialTicks);
        this.openFileButton.render(graphics, mouseX, mouseY, partialTicks);
        this.openFileButton.active = this.list.getSelected() != null && this.list.getSelected() instanceof ConfigTypeSelectionList.TypeEntry && !((ConfigTypeSelectionList.TypeEntry)this.list.getSelected()).isServerConfig;
    }

    public class ConfigTypeSelectionList
    extends ModObjectSelectionList<Entry> {
        public ConfigTypeSelectionList(int buttonSpacing) {
            super(ConfigTypeSelectionScreen.this.minecraft, ConfigTypeSelectionScreen.this.width, ConfigTypeSelectionScreen.this.height - 64, 32, buttonSpacing);
            this.constructEntries();
        }

        public void constructEntries() {
            HashSet addedConfigTypes = new HashSet();
            ConfigTypeSelectionScreen.this.configs.values().forEach(configs -> {
                for (Config config : configs) {
                    if (((Boolean)ClientConfig.ConfigTypeTitles.getValue()).booleanValue() && !addedConfigTypes.contains((Object)config.getType())) {
                        addedConfigTypes.add(config.getType());
                        this.addEntry((AbstractSelectionList.Entry)new Entry(config, true));
                    }
                    if (config.getType() != Config.ConfigType.SERVER || Minecraft.getInstance().isLocalServer()) {
                        this.addEntry((AbstractSelectionList.Entry)new NormalEntry(config));
                        continue;
                    }
                    this.addEntry((AbstractSelectionList.Entry)new ServerEntry(config));
                }
            });
        }

        public int getRowWidth() {
            return this.width;
        }

        public class Entry
        extends ModObjectSelectionList.Entry<Entry> {
            private final boolean isConfigTypeTitle;
            private final Component entryTitle;
            protected final Config config;

            public Entry(Config config, boolean isConfigTypeTitle) {
                this.config = config;
                this.isConfigTypeTitle = isConfigTypeTitle;
                this.entryTitle = Component.literal((String)(config.getType().getFormattedName() + " Configurations")).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW});
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                int entryWidth = entryRight - entryLeft;
                int entryCenter = entryWidth / 2;
                if (this.isConfigTypeTitle) {
                    graphics.drawCenteredString(ConfigTypeSelectionScreen.this.font, this.entryTitle, entryCenter, entryTop + 10, 0xFFFFFF);
                }
            }

            @NotNull
            public Component getNarration() {
                return this.entryTitle;
            }
        }

        public class NormalEntry
        extends TypeEntry {
            public NormalEntry(Config config) {
                super(config, false);
                this.openConfigButton = ConfigScreenUtils.createModifyButton(button -> {
                    ConfigScreen configScreen = new ConfigScreen(ConfigTypeSelectionScreen.this, (Component)Component.literal((String)config.getType().getFormattedName()), ConfigTypeSelectionScreen.this.title.getString(), config, 0);
                    Objects.requireNonNull(ConfigTypeSelectionScreen.this.minecraft).setScreen((Screen)configScreen);
                });
            }
        }

        public class ServerEntry
        extends TypeEntry {
            public ServerEntry(Config config) {
                super(config, true);
                this.openConfigButton = ConfigScreenUtils.createPickWorldButton(button -> {
                    ConfigWorldSelectionScreen worldSelectionScreen = new ConfigWorldSelectionScreen(ConfigTypeSelectionScreen.this, ConfigTypeSelectionScreen.this.title.getString(), config);
                    Objects.requireNonNull(ConfigTypeSelectionScreen.this.minecraft).setScreen((Screen)worldSelectionScreen);
                });
            }
        }

        public class TypeEntry
        extends Entry {
            protected Button openConfigButton;
            protected Button resetButton;
            protected final ImageWidget imageWidget;
            protected final Config config;
            protected final boolean isServerConfig;

            public TypeEntry(Config config, boolean isServerConfig) {
                super(config, false);
                this.config = config;
                this.isServerConfig = isServerConfig;
                if (!this.isServerConfig) {
                    this.resetButton = ConfigScreenUtils.createIconResetButton(button -> config.resetAllConfigs());
                }
                this.imageWidget = ImageWidget.texture((int)40, (int)40, (ResourceLocation)TypeEntry.getImageWidgetLocation(config), (int)40, (int)40);
            }

            @Override
            public void render(GuiGraphics graphics, int index, int entryTop, int entryLeft, int entryRight, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.render(graphics, index, entryTop, entryLeft, entryRight, entryHeight, mouseX, mouseY, hovered, partialTicks);
                int entryWidth = entryRight - entryLeft;
                int entryCenter = entryWidth / 2;
                if (!this.isServerConfig) {
                    this.resetButton.setPosition(entryCenter + 135, entryTop + 8);
                    this.resetButton.render(graphics, mouseX, mouseY, partialTicks);
                    this.resetButton.active = !this.config.allConfigsOnDefault();
                }
                this.imageWidget.setPosition(entryCenter - 160, entryTop - 2);
                this.imageWidget.render(graphics, mouseX, mouseY, partialTicks);
                if (this.openConfigButton != null) {
                    this.openConfigButton.setPosition(entryCenter + 75, entryTop + 8);
                    this.openConfigButton.render(graphics, mouseX, mouseY, partialTicks);
                    graphics.drawString(ConfigTypeSelectionScreen.this.font, this.config.getType().getFormattedName(), entryCenter - 120, entryTop + this.openConfigButton.getHeight() / 2 - 3, 0xFFFFFF);
                    graphics.drawString(ConfigTypeSelectionScreen.this.font, (Component)Component.literal((String)this.config.getFilePath()).withStyle(ChatFormatting.GRAY), entryCenter - 120, entryTop + this.openConfigButton.getHeight() / 2 + 10, 0xFFFFFF);
                }
            }

            private static ResourceLocation getImageWidgetLocation(Config config) {
                return ResourceLocation.fromNamespaceAndPath((String)"configapi", (String)("textures/gui/widget/" + config.getType().extension() + "_file.png"));
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                ConfigTypeSelectionScreen.this.list.setSelected((AbstractSelectionList.Entry)this);
                if (!this.isServerConfig) {
                    return this.openConfigButton.mouseClicked(mouseX, mouseY, button) || this.resetButton.mouseClicked(mouseX, mouseY, button);
                }
                return this.openConfigButton.mouseClicked(mouseX, mouseY, button);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (!this.isServerConfig) {
                    return this.openConfigButton.keyPressed(keyCode, scanCode, modifiers) || this.resetButton.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
                }
                return this.openConfigButton.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
            }

            @Override
            @NotNull
            public Component getNarration() {
                return Component.literal((String)this.config.getFilePath());
            }
        }
    }
}

